/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part;

import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.MultiblockReactor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.WasteEjectionSetting;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.container.ReactorControllerContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.AbstractReactorEntity;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.block.TileCommandDispatcher;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import it.zerono.mods.zerocore.lib.network.INetworkTileEntitySyncProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.Nullable;

public class ReactorControllerEntity
extends AbstractReactorEntity
implements MenuProvider,
INetworkTileEntitySyncProvider {
    public static String COMMAND_WASTE_AUTOMATIC = "autowaste";
    public static String COMMAND_WASTE_MANUAL = "manualwaste";
    public static String COMMAND_SCRAM = "scram";
    public static String COMMAND_VOID_REACTANTS = "voidr";

    public ReactorControllerEntity(BlockPos position, BlockState blockState) {
        super((BlockEntityType)Content.TileEntityTypes.REACTOR_CONTROLLER.get(), position, blockState);
        this.setCommandDispatcher(TileCommandDispatcher.builder().addServerHandler(CommonConstants.COMMAND_ACTIVATE, rce -> rce.setReactorActive(true)).addServerHandler(CommonConstants.COMMAND_DEACTIVATE, rce -> rce.setReactorActive(false)).addServerHandler(COMMAND_WASTE_AUTOMATIC, rce -> rce.setWasteEjectionMode(WasteEjectionSetting.Automatic)).addServerHandler(COMMAND_WASTE_MANUAL, rce -> rce.setWasteEjectionMode(WasteEjectionSetting.Manual)).addServerHandler(COMMAND_VOID_REACTANTS, ReactorControllerEntity::voidReactants).addServerHandler(COMMAND_SCRAM, ReactorControllerEntity::scram).build((AbstractModBlockEntity)this));
    }

    @Override
    protected int getUpdatedModelVariantIndex() {
        return (byte)(this.isMachineAssembled() ? (this.isReactorActive() ? 1 : 2) : 0);
    }

    public void onPostMachineAssembled(MultiblockReactor controller) {
        super.onPostMachineAssembled((AbstractCuboidMultiblockController)controller);
        this.listenForControllerDataUpdates();
    }

    @Override
    public void onMachineActivated() {
        super.onMachineActivated();
        this.requestClientRenderUpdate();
    }

    @Override
    public void onMachineDeactivated() {
        super.onMachineDeactivated();
        this.requestClientRenderUpdate();
    }

    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        super.getDebugMessages(side, messages);
        this.executeOnController(c -> c.getDebugMessages(side, messages));
    }

    public boolean canOpenGui(Level world, BlockPos position, BlockState state) {
        return this.isMachineAssembled();
    }

    public void enlistForUpdates(ServerPlayer player, boolean updateNow) {
        this.executeOnController(c -> c.enlistForUpdates(player, updateNow));
    }

    public void delistFromUpdates(ServerPlayer player) {
        this.executeOnController(c -> c.delistFromUpdates(player));
    }

    public void sendUpdates() {
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
        return new ReactorControllerContainer(windowId, inventory, this);
    }

    public Component m_5446_() {
        return super.getPartDisplayName();
    }

    private void setWasteEjectionMode(WasteEjectionSetting mode) {
        this.executeOnController(c -> c.setWasteEjectionMode(mode));
    }

    private void scram() {
        this.executeOnController(c -> c.setControlRodsInsertionRatio(100));
        this.setReactorActive(false);
    }

    private void voidReactants() {
        this.executeOnController(MultiblockReactor::voidReactants);
    }
}

