/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.render.rotor;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.model.TurbineRotorModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.render.rotor.ShaftSection;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.rotor.RotorShaftState;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.variant.TurbineVariant;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraftforge.common.util.NonNullConsumer;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RotorDescriptor
implements NonNullConsumer<PoseStack> {
    final Direction RotorDirection;
    final int Length;
    final ShaftSection[] Sections;
    final Vector3fc Translation;
    final Supplier<BakedModel> ShaftModel;
    final Supplier<BakedModel> BladeModel;
    final BiConsumer<PoseStack, Float> InitMatrix;
    private final Vector3f _initRotorDirectionVector;
    private final float _initRotationOffsetX;
    private final float _initRotationOffsetY;
    private final float _initRotationOffsetZ;

    public static Builder builder(TurbineVariant variant, Direction rotorDirection, int length) {
        return new Builder(variant, rotorDirection, length);
    }

    public void accept(PoseStack stack) {
        stack.m_85850_().m_252922_().translate(this.Translation);
    }

    private RotorDescriptor(TurbineVariant variant, Direction rotorDirection, int length, List<ShaftSection> sections) {
        this.RotorDirection = rotorDirection;
        this.Length = length;
        this.Sections = sections.toArray(new ShaftSection[0]);
        this.Translation = rotorDirection.m_253071_();
        switch (variant) {
            case Basic: {
                this.ShaftModel = TurbineRotorModelBuilder.BASIC_SHAFT;
                this.BladeModel = TurbineRotorModelBuilder.BASIC_BLADE;
                break;
            }
            case Reinforced: {
                this.ShaftModel = TurbineRotorModelBuilder.REINFORCED_SHAFT;
                this.BladeModel = TurbineRotorModelBuilder.REINFORCED_BLADE;
                break;
            }
            default: {
                this.BladeModel = ModRenderHelper::getMissingModel;
                this.ShaftModel = this.BladeModel;
            }
        }
        this._initRotorDirectionVector = this.RotorDirection.m_253071_();
        this._initRotationOffsetX = 0.0f == this._initRotorDirectionVector.x() ? 0.5f : 0.0f;
        this._initRotationOffsetY = 0.0f == this._initRotorDirectionVector.y() ? 0.5f : 0.0f;
        this._initRotationOffsetZ = 0.0f == this._initRotorDirectionVector.z() ? 0.5f : 0.0f;
        this.InitMatrix = this::initMatrix;
    }

    private void initMatrix(PoseStack stack, float rotorAngle) {
        PoseStack.Pose entry = stack.m_85850_();
        Quaternionf rotation = Axis.m_253057_((Vector3f)this._initRotorDirectionVector).m_252977_(rotorAngle);
        entry.m_252922_().translate(this._initRotationOffsetX, this._initRotationOffsetY, this._initRotationOffsetZ).rotate((Quaternionfc)rotation).translate(-this._initRotationOffsetX, -this._initRotationOffsetY, -this._initRotationOffsetZ);
        entry.m_252943_().rotate((Quaternionfc)rotation);
    }

    public static class Builder {
        private final TurbineVariant _variant;
        private final Direction _rotorDirection;
        private final int _length;
        private final List<ShaftSection> _shaft;

        public RotorDescriptor build() {
            return new RotorDescriptor(this._variant, this._rotorDirection, this._length, this._shaft);
        }

        public Builder section(RotorShaftState state, NonNullConsumer<ShaftSection.Builder> consumer) {
            ShaftSection.Builder builder = ShaftSection.builder(state);
            consumer.accept((Object)builder);
            this._shaft.add(builder.build());
            return this;
        }

        private Builder(TurbineVariant variant, Direction rotorDirection, int length) {
            this._variant = variant;
            this._rotorDirection = rotorDirection;
            this._length = length;
            this._shaft = Lists.newArrayList();
        }
    }
}

