/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.docs.formatter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class ClassResolver {
    public static Set<Class<?>> skipped = new HashSet();
    public static Set<String> skippedPrefixes = new HashSet<String>();

    public static void skipClass(Class<?> ... clazz) {
        skipped.addAll(Arrays.asList(clazz));
    }

    public static void skipPrefix(String ... prefixes) {
        skippedPrefixes.addAll(List.of(prefixes));
    }

    public static boolean acceptMethod(String methodName) {
        return !methodName.equals("constructor") && !Pattern.matches("^[fm]_[\\d_]+$", methodName);
    }

    public static boolean acceptField(String fieldName) {
        return !fieldName.equals("constructor") && !Pattern.matches("^[fm]_[\\d_]+$", fieldName);
    }

    public static boolean acceptClass(String className) {
        try {
            String string = Class.forName(className).getSimpleName();
        }
        catch (Throwable e) {
            return false;
        }
        return skippedPrefixes.stream().noneMatch(className::startsWith);
    }

    public static void init() {
        ClassResolver.skipClass(Object.class);
        ClassResolver.skipClass(Void.class, Void.TYPE);
        ClassResolver.skipClass(String.class, Character.class, Character.TYPE);
        ClassResolver.skipClass(Long.class, Long.TYPE);
        ClassResolver.skipClass(Integer.class, Integer.TYPE);
        ClassResolver.skipClass(Short.class, Short.TYPE);
        ClassResolver.skipClass(Byte.class, Byte.TYPE);
        ClassResolver.skipClass(Double.class, Double.TYPE, Float.class, Float.TYPE);
        ClassResolver.skipClass(Boolean.class, Boolean.TYPE);
        ClassResolver.skipPrefix("com.legacy.structure_gel.core.mixin");
    }
}

