/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.specials;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.probejs.ProbeCommands;
import com.probejs.ProbeJS;
import com.probejs.ProbePaths;
import com.probejs.docs.formatter.NameResolver;
import com.probejs.jdoc.document.DocumentClass;
import com.probejs.specials.special.FormatterLang;
import com.probejs.util.RLHelper;
import com.probejs.util.json.JArray;
import com.probejs.util.json.JObject;
import com.probejs.util.json.JPrimitive;
import dev.architectury.platform.Platform;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.resources.language.ClientLanguage;
import net.minecraft.core.Registry;
import net.minecraft.locale.Language;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class SchemaCompiler {
    public static JsonObject toLangSchema() {
        return JObject.create().add("type", JPrimitive.create("object")).add("properties", Language.m_128107_() instanceof ClientLanguage ? JObject.create().addAll(FormatterLang.getLangKeys("en_us").filter(e -> {
            String s = (String)e.getKey();
            return !s.startsWith("_") && !s.startsWith("$");
        }).map(entry -> new Pair((Object)((String)entry.getKey()), (Object)JObject.create().add("type", JPrimitive.create("string")).add("description", JPrimitive.create((String)entry.getValue()))))) : JObject.create()).serialize();
    }

    public static JsonObject toClassDefinition(List<DocumentClass> mergedDocs) {
        return JObject.create().add("definitions", JObject.create().add("typeClassName", JObject.create().add("enum", JArray.create().addAll(mergedDocs.stream().map(DocumentClass::getName).map(JPrimitive::create)).addAll(NameResolver.resolvedPrimitives.stream().map(JPrimitive::create))).add("type", JPrimitive.create("string")))).serialize();
    }

    public static JsonObject toLangKeyDefinition() {
        return JObject.create().add("definitions", JObject.create().add("typeLangKey", JObject.create().add("type", JPrimitive.create("string")).add("enum", JArray.create().addAll(Language.m_128107_() instanceof ClientLanguage ? FormatterLang.getLangKeys("en_us").map(Map.Entry::getKey).map(JPrimitive::create) : Stream.empty())))).serialize();
    }

    public static <T> JObject toRegistryDefinition(ResourceKey<Registry<T>> key) {
        return JObject.create().add("type", JPrimitive.create("string")).add("enum", JArray.create().addAll(ProbeCommands.getRegistry(key).m_6566_().stream().map(ResourceLocation::toString).map(JPrimitive::create)));
    }

    public static <T> void toRegistryDefinitions() throws IOException {
        JObject definitions = JObject.create();
        ProbeCommands.COMMAND_LEVEL.m_9598_().m_206193_().forEach(entry -> {
            JObject schema = SchemaCompiler.toRegistryDefinition(entry.f_206233_());
            definitions.add("type%s".formatted(RLHelper.rlToTitle(entry.f_206233_().m_135782_().m_135815_())), schema);
        });
        SchemaCompiler.compileSchema("probe.registry-definitions.json", definitions.serialize());
    }

    private static void compileSchema(String fileName, JsonObject schema) throws IOException {
        Path schemaPath = ProbePaths.WORKSPACE_SETTINGS.resolve(fileName);
        BufferedWriter writer = Files.newBufferedWriter(schemaPath, new OpenOption[0]);
        writer.write(ProbeJS.GSON.toJson((JsonElement)schema));
        writer.close();
    }

    public static void compile(List<DocumentClass> mergedDocs) throws IOException {
        SchemaCompiler.compileSchema("probe.lang-schema.json", SchemaCompiler.toLangSchema());
        SchemaCompiler.compileSchema("probe.class-definitions.json", SchemaCompiler.toClassDefinition(mergedDocs));
        SchemaCompiler.compileSchema("probe.lang_key-definitions.json", SchemaCompiler.toLangKeyDefinition());
        SchemaCompiler.toRegistryDefinitions();
        Path schemaDoc = ProbePaths.WORKSPACE_SETTINGS.resolve("probe.doc-schema.json");
        Platform.getMod((String)"probejs").findResource(new String[]{"probe.doc-schema.json"}).ifPresent(path -> {
            try {
                Files.copy(path, schemaDoc, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

