/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration.object;

import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.mantle.registration.object.IdAwareObject;
import slimeknights.mantle.util.RegistryHelper;

public class ItemObject<I extends ItemLike>
implements Supplier<I>,
ItemLike,
IdAwareObject {
    private final Supplier<? extends I> entry;
    private final ResourceLocation id;

    public ItemObject(DefaultedRegistry<I> registry, I entry) {
        this.entry = RegistryHelper.getHolder(registry, entry);
        this.id = registry.m_7981_(entry);
    }

    public ItemObject(RegistryObject<? extends I> object) {
        this.entry = object;
        this.id = object.getId();
    }

    protected ItemObject(ItemObject<? extends I> object) {
        this.entry = object.entry;
        this.id = object.id;
    }

    @Override
    public I get() {
        return (I)Objects.requireNonNull((ItemLike)this.entry.get(), () -> "Item Object not present " + this.id);
    }

    @Nullable
    public I getOrNull() {
        try {
            return (I)((ItemLike)this.entry.get());
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public Item m_5456_() {
        return this.get().m_5456_();
    }

    public ItemObject(Supplier<? extends I> entry, ResourceLocation id) {
        this.entry = entry;
        this.id = id;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }
}

