/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.areas;

import com.google.gson.JsonObject;
import mcjty.incontrol.ErrorHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public record Area(ResourceKey<Level> dimension, String name, Type type, BlockPos center, int dimx, int dimy, int dimz) {
    public static Builder create() {
        return new Builder();
    }

    public static boolean parse(JsonObject object, Builder builder) {
        if (!object.has("dimension")) {
            ErrorHandler.error("Area has no dimension!");
            return false;
        }
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(object.get("dimension").getAsString()));
        builder.dimension((ResourceKey<Level>)key);
        if (!object.has("name")) {
            ErrorHandler.error("Area has no name!");
            return false;
        }
        builder.name(object.get("name").getAsString());
        if (!object.has("type")) {
            ErrorHandler.error("Area '" + builder.name + "' has no type!");
            return false;
        }
        builder.type(Type.valueOf(object.get("type").getAsString().toUpperCase()));
        if (!object.has("x")) {
            ErrorHandler.error("Area '" + builder.name + "' has no x!");
            return false;
        }
        int x = object.get("x").getAsInt();
        if (!object.has("y")) {
            ErrorHandler.error("Area '" + builder.name + "' has no y!");
            return false;
        }
        int y = object.get("y").getAsInt();
        if (!object.has("z")) {
            ErrorHandler.error("Area '" + builder.name + "' has no z!");
            return false;
        }
        int z = object.get("z").getAsInt();
        builder.center(new BlockPos(x, y, z));
        if (!object.has("dimx")) {
            ErrorHandler.error("Area '" + builder.name + "' has no dimx!");
            return false;
        }
        int dimx = object.get("dimx").getAsInt();
        if (!object.has("dimy")) {
            ErrorHandler.error("Area '" + builder.name + "' has no dimy!");
            return false;
        }
        int dimy = object.get("dimy").getAsInt();
        if (!object.has("dimz")) {
            ErrorHandler.error("Area '" + builder.name + "' has no dimz!");
            return false;
        }
        int dimz = object.get("dimz").getAsInt();
        builder.dim(dimx, dimy, dimz);
        return true;
    }

    public boolean isInArea(int x, int y, int z) {
        if (this.type == Type.BOX) {
            return this.isInBox(x, y, z);
        }
        return this.isInEllipsoid(x, y, z);
    }

    private boolean isInBox(int x, int y, int z) {
        int dx = Math.abs(x - this.center.m_123341_());
        int dy = Math.abs(y - this.center.m_123342_());
        int dz = Math.abs(z - this.center.m_123343_());
        return dx <= this.dimx && dy <= this.dimy && dz <= this.dimz;
    }

    private boolean isInEllipsoid(int x, int y, int z) {
        int dz;
        int dy;
        int dx = Math.abs(x - this.center.m_123341_());
        return dx * dx / (this.dimx * this.dimx) + (dy = Math.abs(y - this.center.m_123342_())) * dy / (this.dimy * this.dimy) + (dz = Math.abs(z - this.center.m_123343_())) * dz / (this.dimz * this.dimz) <= 1;
    }

    static enum Type {
        BOX,
        SPHERE;

    }

    public static class Builder {
        private String name;
        private ResourceKey<Level> dimension;
        private Type type;
        private BlockPos center;
        private int dimx;
        private int dimy;
        private int dimz;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder dimension(ResourceKey<Level> dimension) {
            this.dimension = dimension;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder center(BlockPos center) {
            this.center = center;
            return this;
        }

        public Builder dim(int dimx, int dimy, int dimz) {
            this.dimx = dimx;
            this.dimy = dimy;
            this.dimz = dimz;
            return this;
        }

        public Area build() {
            return new Area(this.dimension, this.name, this.type, this.center, this.dimx, this.dimy, this.dimz);
        }
    }
}

