/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.rules;

import com.google.gson.JsonElement;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import mcjty.incontrol.ErrorHandler;
import mcjty.incontrol.compat.ModRuleCompatibilityLayer;
import mcjty.incontrol.data.PhaseTools;
import mcjty.incontrol.rules.support.GenericRuleEvaluator;
import mcjty.incontrol.rules.support.ICResult;
import mcjty.incontrol.rules.support.RuleKeys;
import mcjty.incontrol.rules.support.SpawnWhen;
import mcjty.incontrol.setup.Config;
import mcjty.incontrol.tools.rules.IEventQuery;
import mcjty.incontrol.tools.rules.IModRuleCompatibilityLayer;
import mcjty.incontrol.tools.rules.RuleBase;
import mcjty.incontrol.tools.typed.Attribute;
import mcjty.incontrol.tools.typed.AttributeMap;
import mcjty.incontrol.tools.typed.GenericAttributeMapFactory;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;

public class SpawnRule
extends RuleBase<RuleBase.EventGetter> {
    public static final IEventQuery<MobSpawnEvent.FinalizeSpawn> EVENT_QUERY = new IEventQuery<MobSpawnEvent.FinalizeSpawn>(){

        @Override
        public LevelAccessor getWorld(MobSpawnEvent.FinalizeSpawn o) {
            return o.getLevel();
        }

        @Override
        public BlockPos getPos(MobSpawnEvent.FinalizeSpawn o) {
            return new BlockPos((int)o.getX(), (int)o.getY(), (int)o.getZ());
        }

        @Override
        public BlockPos getValidBlockPos(MobSpawnEvent.FinalizeSpawn o) {
            return new BlockPos((int)o.getX(), (int)(o.getY() - 1.0), (int)o.getZ());
        }

        @Override
        public int getY(MobSpawnEvent.FinalizeSpawn o) {
            return (int)o.getY();
        }

        @Override
        public Entity getEntity(MobSpawnEvent.FinalizeSpawn o) {
            return o.getEntity();
        }

        @Override
        public DamageSource getSource(MobSpawnEvent.FinalizeSpawn o) {
            return null;
        }

        @Override
        public Entity getAttacker(MobSpawnEvent.FinalizeSpawn o) {
            return null;
        }

        @Override
        public Player getPlayer(MobSpawnEvent.FinalizeSpawn o) {
            return SpawnRule.getClosestPlayer((LevelAccessor)o.getLevel(), new BlockPos((int)o.getX(), (int)o.getY(), (int)o.getZ()));
        }

        @Override
        public ItemStack getItem(MobSpawnEvent.FinalizeSpawn o) {
            return ItemStack.f_41583_;
        }
    };
    public static final IEventQuery<MobSpawnEvent.PositionCheck> EVENT_QUERY_POSITION = new IEventQuery<MobSpawnEvent.PositionCheck>(){

        @Override
        public LevelAccessor getWorld(MobSpawnEvent.PositionCheck o) {
            return o.getLevel();
        }

        @Override
        public BlockPos getPos(MobSpawnEvent.PositionCheck o) {
            return new BlockPos((int)o.getX(), (int)o.getY(), (int)o.getZ());
        }

        @Override
        public BlockPos getValidBlockPos(MobSpawnEvent.PositionCheck o) {
            return new BlockPos((int)o.getX(), (int)(o.getY() - 1.0), (int)o.getZ());
        }

        @Override
        public int getY(MobSpawnEvent.PositionCheck o) {
            return (int)o.getY();
        }

        @Override
        public Entity getEntity(MobSpawnEvent.PositionCheck o) {
            return o.getEntity();
        }

        @Override
        public DamageSource getSource(MobSpawnEvent.PositionCheck o) {
            return null;
        }

        @Override
        public Entity getAttacker(MobSpawnEvent.PositionCheck o) {
            return null;
        }

        @Override
        public Player getPlayer(MobSpawnEvent.PositionCheck o) {
            return SpawnRule.getClosestPlayer((LevelAccessor)o.getLevel(), new BlockPos((int)o.getX(), (int)o.getY(), (int)o.getZ()));
        }

        @Override
        public ItemStack getItem(MobSpawnEvent.PositionCheck o) {
            return ItemStack.f_41583_;
        }
    };
    public static final IEventQuery<MobSpawnEvent.AllowDespawn> EVENT_QUERY_DESPAWN = new IEventQuery<MobSpawnEvent.AllowDespawn>(){

        @Override
        public LevelAccessor getWorld(MobSpawnEvent.AllowDespawn o) {
            return o.getLevel();
        }

        @Override
        public BlockPos getPos(MobSpawnEvent.AllowDespawn o) {
            return new BlockPos((int)o.getX(), (int)o.getY(), (int)o.getZ());
        }

        @Override
        public BlockPos getValidBlockPos(MobSpawnEvent.AllowDespawn o) {
            return new BlockPos((int)o.getX(), (int)(o.getY() - 1.0), (int)o.getZ());
        }

        @Override
        public int getY(MobSpawnEvent.AllowDespawn o) {
            return (int)o.getY();
        }

        @Override
        public Entity getEntity(MobSpawnEvent.AllowDespawn o) {
            return o.getEntity();
        }

        @Override
        public DamageSource getSource(MobSpawnEvent.AllowDespawn o) {
            return null;
        }

        @Override
        public Entity getAttacker(MobSpawnEvent.AllowDespawn o) {
            return null;
        }

        @Override
        public Player getPlayer(MobSpawnEvent.AllowDespawn o) {
            return SpawnRule.getClosestPlayer((LevelAccessor)o.getLevel(), new BlockPos((int)o.getX(), (int)o.getY(), (int)o.getZ()));
        }

        @Override
        public ItemStack getItem(MobSpawnEvent.AllowDespawn o) {
            return ItemStack.f_41583_;
        }
    };
    public static final IEventQuery<EntityJoinLevelEvent> EVENT_QUERY_JOIN = new IEventQuery<EntityJoinLevelEvent>(){

        public Level getWorld(EntityJoinLevelEvent o) {
            return o.getLevel();
        }

        @Override
        public BlockPos getPos(EntityJoinLevelEvent o) {
            return o.getEntity().m_20183_();
        }

        @Override
        public BlockPos getValidBlockPos(EntityJoinLevelEvent o) {
            return o.getEntity().m_20183_().m_7495_();
        }

        @Override
        public int getY(EntityJoinLevelEvent o) {
            return o.getEntity().m_20183_().m_123342_();
        }

        @Override
        public Entity getEntity(EntityJoinLevelEvent o) {
            return o.getEntity();
        }

        @Override
        public DamageSource getSource(EntityJoinLevelEvent o) {
            return null;
        }

        @Override
        public Entity getAttacker(EntityJoinLevelEvent o) {
            return null;
        }

        @Override
        public Player getPlayer(EntityJoinLevelEvent o) {
            return SpawnRule.getClosestPlayer((LevelAccessor)o.getLevel(), o.getEntity().m_20183_());
        }

        @Override
        public ItemStack getItem(EntityJoinLevelEvent o) {
            return ItemStack.f_41583_;
        }
    };
    private static final GenericAttributeMapFactory FACTORY = new GenericAttributeMapFactory();
    private final SpawnWhen when;
    private final GenericRuleEvaluator ruleEvaluator;
    private ICResult result = null;
    private boolean doContinue = false;

    private static Player getClosestPlayer(LevelAccessor world, BlockPos pos) {
        return world.m_45924_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)((Integer)Config.PERPLAYER_RADIUS.get()).intValue(), false);
    }

    private SpawnRule(AttributeMap map, SpawnWhen when, Set<String> phases, int index) {
        super(phases, index);
        this.when = when;
        this.ruleEvaluator = new GenericRuleEvaluator(map);
        this.addActions(map, new ModRuleCompatibilityLayer());
        if (!map.isEmpty()) {
            StringBuffer buffer = new StringBuffer();
            map.getKeys().forEach(k -> buffer.append(k).append(' '));
            ErrorHandler.error("Invalid keywords in spawn rule: " + String.valueOf(buffer));
        }
    }

    public static SpawnRule parse(JsonElement element, int index) {
        if (element == null) {
            return null;
        }
        AttributeMap map = FACTORY.parse(element, "spawn.json");
        String whenS = element.getAsJsonObject().has("when") ? element.getAsJsonObject().get("when").getAsString() : SpawnWhen.POSITION.name();
        SpawnWhen when = SpawnWhen.getByName(whenS);
        if (when == null) {
            ErrorHandler.error("Invalid spawn rule 'when' value '" + whenS + "'!. Should be one of " + Arrays.toString((Object[])SpawnWhen.values()));
        }
        return new SpawnRule(map, when, PhaseTools.getPhases(element), index);
    }

    @Override
    protected void addActions(AttributeMap map, IModRuleCompatibilityLayer layer) {
        super.addActions(map, layer);
        map.consumeOrElse(RuleKeys.ACTION_RESULT, br -> {
            this.result = "default".equals(br) || br.startsWith("def") ? ICResult.DEFAULT : ("allow".equals(br) || "true".equals(br) ? ICResult.ALLOW : ("deny_with_actions".equals(br) ? ICResult.DENY_WITH_ACTIONS : ICResult.DENY));
        }, () -> {
            this.result = ICResult.DEFAULT;
        });
        map.consume(RuleKeys.ACTION_CONTINUE, v -> {
            this.doContinue = v;
        });
    }

    public boolean match(MobSpawnEvent.FinalizeSpawn event) {
        return this.ruleEvaluator.match(event, EVENT_QUERY);
    }

    public boolean match(MobSpawnEvent.PositionCheck event) {
        return this.ruleEvaluator.match(event, EVENT_QUERY_POSITION);
    }

    public boolean match(MobSpawnEvent.AllowDespawn event) {
        return this.ruleEvaluator.match(event, EVENT_QUERY_DESPAWN);
    }

    public boolean match(EntityJoinLevelEvent event) {
        return this.ruleEvaluator.match(event, EVENT_QUERY_JOIN);
    }

    public void action(final MobSpawnEvent.FinalizeSpawn event) {
        RuleBase.EventGetter getter = new RuleBase.EventGetter(){

            @Override
            public LivingEntity getEntityLiving() {
                return event.getEntity();
            }

            @Override
            public Player getPlayer() {
                return null;
            }

            @Override
            public LevelAccessor getWorld() {
                return event.getLevel();
            }

            @Override
            public BlockPos getPosition() {
                return event.getEntity().m_20183_();
            }
        };
        for (Consumer action : this.actions) {
            action.accept(getter);
        }
    }

    public void action(final MobSpawnEvent.PositionCheck event) {
        RuleBase.EventGetter getter = new RuleBase.EventGetter(){

            @Override
            public LivingEntity getEntityLiving() {
                return event.getEntity();
            }

            @Override
            public Player getPlayer() {
                return null;
            }

            @Override
            public LevelAccessor getWorld() {
                return event.getLevel();
            }

            @Override
            public BlockPos getPosition() {
                return event.getEntity().m_20183_();
            }
        };
        for (Consumer action : this.actions) {
            action.accept(getter);
        }
    }

    public void action(final MobSpawnEvent.AllowDespawn event) {
        RuleBase.EventGetter getter = new RuleBase.EventGetter(){

            @Override
            public LivingEntity getEntityLiving() {
                return event.getEntity();
            }

            @Override
            public Player getPlayer() {
                return null;
            }

            @Override
            public LevelAccessor getWorld() {
                return event.getLevel();
            }

            @Override
            public BlockPos getPosition() {
                return event.getEntity().m_20183_();
            }
        };
        for (Consumer action : this.actions) {
            action.accept(getter);
        }
    }

    public void action(final EntityJoinLevelEvent event) {
        RuleBase.EventGetter getter = new RuleBase.EventGetter(){

            @Override
            public LivingEntity getEntityLiving() {
                return event.getEntity() instanceof LivingEntity ? (LivingEntity)event.getEntity() : null;
            }

            @Override
            public Player getPlayer() {
                return null;
            }

            public Level getWorld() {
                return event.getLevel();
            }

            @Override
            public BlockPos getPosition() {
                return event.getEntity() != null ? event.getEntity().m_20183_() : null;
            }
        };
        for (Consumer action : this.actions) {
            action.accept(getter);
        }
    }

    @Nonnull
    public ICResult getResult() {
        return this.result;
    }

    public boolean isDoContinue() {
        return this.doContinue;
    }

    public SpawnWhen getWhen() {
        return this.when;
    }

    static {
        FACTORY.attribute(Attribute.create(RuleKeys.WHEN)).attribute(Attribute.createMulti(RuleKeys.PHASE)).attribute(Attribute.create(RuleKeys.NUMBER)).attribute(Attribute.create(RuleKeys.TIME)).attribute(Attribute.create(RuleKeys.MINTIME)).attribute(Attribute.create(RuleKeys.MAXTIME)).attribute(Attribute.create(RuleKeys.DAYCOUNT)).attribute(Attribute.create(RuleKeys.MINDAYCOUNT)).attribute(Attribute.create(RuleKeys.MAXDAYCOUNT)).attribute(Attribute.create(RuleKeys.MINCOUNT)).attribute(Attribute.create(RuleKeys.MAXCOUNT)).attribute(Attribute.create(RuleKeys.LIGHT)).attribute(Attribute.create(RuleKeys.MINLIGHT)).attribute(Attribute.create(RuleKeys.MAXLIGHT)).attribute(Attribute.create(RuleKeys.MINLIGHT_FULL)).attribute(Attribute.create(RuleKeys.MAXLIGHT_FULL)).attribute(Attribute.create(RuleKeys.HEIGHT)).attribute(Attribute.create(RuleKeys.MINHEIGHT)).attribute(Attribute.create(RuleKeys.MAXHEIGHT)).attribute(Attribute.create(RuleKeys.MINDIFFICULTY)).attribute(Attribute.create(RuleKeys.MAXDIFFICULTY)).attribute(Attribute.create(RuleKeys.MINSPAWNDIST)).attribute(Attribute.create(RuleKeys.MAXSPAWNDIST)).attribute(Attribute.create(RuleKeys.RANDOM)).attribute(Attribute.create(RuleKeys.CANSPAWNHERE)).attribute(Attribute.create(RuleKeys.NOTCOLLIDING)).attribute(Attribute.create(RuleKeys.SPAWNER)).attribute(Attribute.createMulti(RuleKeys.SPAWNTYPE)).attribute(Attribute.create(RuleKeys.INCONTROL)).attribute(Attribute.create(RuleKeys.EVENTSPAWN)).attribute(Attribute.create(RuleKeys.INBUILDING)).attribute(Attribute.create(RuleKeys.INMULTIBUILDING)).attribute(Attribute.createMulti(RuleKeys.BUILDING)).attribute(Attribute.createMulti(RuleKeys.MULTIBUILDING)).attribute(Attribute.create(RuleKeys.INCITY)).attribute(Attribute.create(RuleKeys.INSTREET)).attribute(Attribute.create(RuleKeys.INSPHERE)).attribute(Attribute.create(RuleKeys.GAMESTAGE)).attribute(Attribute.create(RuleKeys.PASSIVE)).attribute(Attribute.create(RuleKeys.HOSTILE)).attribute(Attribute.create(RuleKeys.BABY)).attribute(Attribute.create(RuleKeys.CAVE)).attribute(Attribute.create(RuleKeys.SEESKY)).attribute(Attribute.create(RuleKeys.SLIME)).attribute(Attribute.create(RuleKeys.WEATHER)).attribute(Attribute.createMulti(RuleKeys.BIOMETAGS)).attribute(Attribute.create(RuleKeys.DIFFICULTY)).attribute(Attribute.create(RuleKeys.HASSTRUCTURE)).attribute(Attribute.createMulti(RuleKeys.STRUCTURE)).attribute(Attribute.createMulti(RuleKeys.STRUCTURETAGS)).attribute(Attribute.create(RuleKeys.WINTER)).attribute(Attribute.create(RuleKeys.SUMMER)).attribute(Attribute.create(RuleKeys.SPRING)).attribute(Attribute.create(RuleKeys.AUTUMN)).attribute(Attribute.createMulti(RuleKeys.MOB)).attribute(Attribute.createMulti(RuleKeys.MOD)).attribute(Attribute.create(RuleKeys.AREA)).attribute(Attribute.createMulti(RuleKeys.BLOCK)).attribute(Attribute.create(RuleKeys.BLOCKOFFSET)).attribute(Attribute.createMulti(RuleKeys.BIOME)).attribute(Attribute.createMulti(RuleKeys.BIOMETYPE)).attribute(Attribute.createMulti(RuleKeys.DIMENSION)).attribute(Attribute.createMulti(RuleKeys.DIMENSION_MOD)).attribute(Attribute.create(RuleKeys.STATE)).attribute(Attribute.createMulti(RuleKeys.SCOREBOARDTAGS_ALL)).attribute(Attribute.createMulti(RuleKeys.SCOREBOARDTAGS_ANY)).attribute(Attribute.createMulti(RuleKeys.HELMET)).attribute(Attribute.createMulti(RuleKeys.CHESTPLATE)).attribute(Attribute.createMulti(RuleKeys.LEGGINGS)).attribute(Attribute.createMulti(RuleKeys.BOOTS)).attribute(Attribute.createMulti(RuleKeys.AMULET)).attribute(Attribute.createMulti(RuleKeys.RING)).attribute(Attribute.createMulti(RuleKeys.BELT)).attribute(Attribute.createMulti(RuleKeys.TRINKET)).attribute(Attribute.createMulti(RuleKeys.HEAD)).attribute(Attribute.createMulti(RuleKeys.BODY)).attribute(Attribute.createMulti(RuleKeys.CHARM)).attribute(Attribute.createMulti(RuleKeys.PLAYER_HELDITEM)).attribute(Attribute.createMulti(RuleKeys.OFFHANDITEM)).attribute(Attribute.createMulti(RuleKeys.BOTHHANDSITEM)).attribute(Attribute.create(RuleKeys.ACTION_CUSTOMEVENT)).attribute(Attribute.create(RuleKeys.ACTION_CONTINUE)).attribute(Attribute.create(RuleKeys.ACTION_RESULT)).attribute(Attribute.create(RuleKeys.ACTION_MESSAGE)).attribute(Attribute.create(RuleKeys.ACTION_ADDSCOREBOARDTAGS)).attribute(Attribute.create(RuleKeys.ACTION_HEALTHSET)).attribute(Attribute.create(RuleKeys.ACTION_HEALTHMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_HEALTHADD)).attribute(Attribute.create(RuleKeys.ACTION_SPEEDSET)).attribute(Attribute.create(RuleKeys.ACTION_SPEEDMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_SPEEDADD)).attribute(Attribute.create(RuleKeys.ACTION_DAMAGESET)).attribute(Attribute.create(RuleKeys.ACTION_DAMAGEMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_DAMAGEADD)).attribute(Attribute.create(RuleKeys.ACTION_ARMORSET)).attribute(Attribute.create(RuleKeys.ACTION_ARMORMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_ARMORADD)).attribute(Attribute.create(RuleKeys.ACTION_ARMORTOUGHNESSSET)).attribute(Attribute.create(RuleKeys.ACTION_ARMORTOUGHNESSMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_ARMORTOUGHNESSADD)).attribute(Attribute.create(RuleKeys.ACTION_ATTACKSPEEDSET)).attribute(Attribute.create(RuleKeys.ACTION_ATTACKSPEEDMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_ATTACKSPEEDADD)).attribute(Attribute.create(RuleKeys.ACTION_FOLLOWRANGESET)).attribute(Attribute.create(RuleKeys.ACTION_FOLLOWRANGEMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_FOLLOWRANGEADD)).attribute(Attribute.create(RuleKeys.ACTION_KNOCKBACKSET)).attribute(Attribute.create(RuleKeys.ACTION_KNOCKBACKMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_KNOCKBACKADD)).attribute(Attribute.create(RuleKeys.ACTION_KNOCKBACKRESISTANCESET)).attribute(Attribute.create(RuleKeys.ACTION_KNOCKBACKRESISTANCEMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_KNOCKBACKRESISTANCEADD)).attribute(Attribute.create(RuleKeys.ACTION_SIZEMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_SIZEADD)).attribute(Attribute.create(RuleKeys.ACTION_ANGRY)).attribute(Attribute.create(RuleKeys.ACTION_MOBNBT)).attribute(Attribute.create(RuleKeys.ACTION_CUSTOMNAME)).attribute(Attribute.create(RuleKeys.ACTION_SETPHASE)).attribute(Attribute.create(RuleKeys.ACTION_CLEARPHASE)).attribute(Attribute.create(RuleKeys.ACTION_TOGGLEPHASE)).attribute(Attribute.create(RuleKeys.ACTION_CHANGENUMBER)).attribute(Attribute.createMulti(RuleKeys.ACTION_HELDITEM)).attribute(Attribute.createMulti(RuleKeys.ACTION_ARMORBOOTS)).attribute(Attribute.createMulti(RuleKeys.ACTION_ARMORLEGS)).attribute(Attribute.createMulti(RuleKeys.ACTION_ARMORCHEST)).attribute(Attribute.createMulti(RuleKeys.ACTION_ARMORHELMET)).attribute(Attribute.createMulti(RuleKeys.ACTION_POTION)).attribute(Attribute.createMulti(RuleKeys.ACTION_POTION_NOPARTICLES)).attribute(Attribute.create(RuleKeys.ACTION_NODESPAWN));
    }
}

