/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.spawner;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import mcjty.incontrol.ErrorHandler;
import mcjty.incontrol.compat.GameStageSupport;
import mcjty.incontrol.compat.LostCitySupport;
import mcjty.incontrol.compat.SereneSeasonsSupport;
import mcjty.incontrol.rules.support.GenericRuleEvaluator;
import mcjty.incontrol.setup.ModSetup;
import mcjty.incontrol.tools.cache.StructureCache;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.apache.commons.lang3.function.TriFunction;

public class PositionCheck {
    private final TriFunction<Level, BlockPos, Player, Boolean> extraConditions;
    private static final Map<String, Cmd> CONDITIONS = new HashMap<String, Cmd>();

    private PositionCheck(Builder builder, boolean defaultIfNone) {
        this.extraConditions = builder.extraConditions == null ? (level, blockPos, player) -> defaultIfNone : builder.extraConditions;
    }

    @Nonnull
    public TriFunction<Level, BlockPos, Player, Boolean> getExtraConditions() {
        return this.extraConditions;
    }

    public static Builder create(BiFunction<TriFunction<Level, BlockPos, Player, Boolean>, TriFunction<Level, BlockPos, Player, Boolean>, TriFunction<Level, BlockPos, Player, Boolean>> combiner) {
        return new Builder(combiner);
    }

    public static void parse(JsonObject object, Builder builder) {
        for (String attr : object.keySet()) {
            Cmd cmd = CONDITIONS.get(attr);
            if (cmd == null) {
                ErrorHandler.error("Invalid condition '" + attr + "' for spawner rule!");
                return;
            }
            switch (cmd) {
                case MINTIME: {
                    int mintime = object.getAsJsonPrimitive("mintime").getAsInt();
                    builder.extraCondition((TriFunction<Level, BlockPos, Player, Boolean>)((TriFunction)(level, pos, player) -> (int)(level.m_46468_() % 24000L) >= mintime));
                    break;
                }
                case MAXTIME: {
                    int maxtime = object.getAsJsonPrimitive("maxtime").getAsInt();
                    builder.extraCondition((TriFunction<Level, BlockPos, Player, Boolean>)((TriFunction)(level, pos, player) -> (int)(level.m_46468_() % 24000L) <= maxtime));
                    break;
                }
                case MINLIGHT: {
                    int minlight = object.getAsJsonPrimitive("minlight").getAsInt();
                    builder.extraCondition((TriFunction<Level, BlockPos, Player, Boolean>)((TriFunction)(level, pos, player) -> level.m_45517_(LightLayer.BLOCK, pos) >= minlight));
                    break;
                }
                case MAXLIGHT: {
                    int maxlight = object.getAsJsonPrimitive("maxlight").getAsInt();
                    builder.extraCondition((TriFunction<Level, BlockPos, Player, Boolean>)((TriFunction)(level, pos, player) -> level.m_45517_(LightLayer.BLOCK, pos) <= maxlight));
                    break;
                }
                case MINLIGHT_FULL: {
                    int minlight = object.getAsJsonPrimitive("minlight_full").getAsInt();
                    builder.extraCondition((TriFunction<Level, BlockPos, Player, Boolean>)((TriFunction)(level, pos, player) -> level.m_46803_(pos) >= minlight));
                    break;
                }
                case MAXLIGHT_FULL: {
                    int maxlight = object.getAsJsonPrimitive("maxlight_full").getAsInt();
                    builder.extraCondition((TriFunction<Level, BlockPos, Player, Boolean>)((TriFunction)(level, pos, player) -> level.m_46803_(pos) <= maxlight));
                    break;
                }
                case BIOME: {
                    ResourceLocation key2;
                    HashSet<Object> keys;
                    JsonElement value = object.get(attr);
                    if (value.isJsonArray()) {
                        keys = new HashSet();
                        for (JsonElement element : value.getAsJsonArray()) {
                            key2 = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(element.getAsString()));
                            keys.add(key2);
                        }
                        Predicate<ResourceKey> predicate = key -> keys.contains(key);
                        builder.extraCondition((TriFunction<Level, BlockPos, Player, Boolean>)((TriFunction)(level, pos, player) -> level.m_204166_(pos).m_203425_(predicate)));
                        break;
                    }
                    ResourceKey key3 = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(value.getAsString()));
                    builder.extraCondition((TriFunction<Level, BlockPos, Player, Boolean>)((TriFunction)(level, pos, player) -> level.m_204166_(pos).m_203565_(key3)));
                    break;
                }
                case BIOMETAGS: {
                    ResourceLocation key2;
                    HashSet<Object> keys;
                    JsonElement value = object.get(attr);
                    if (value.isJsonArray()) {
                        keys = new HashSet();
                        for (JsonElement element : value.getAsJsonArray()) {
                            key2 = new ResourceLocation(element.getAsString());
                            keys.add(TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)key2));
                        }
                        builder.extraCondition((TriFunction<Level, BlockPos, Player, Boolean>)((TriFunction)(level, pos, player) -> {
                            for (TagKey key : keys) {
                                Holder biome = level.m_204166_(pos);
                                if (!biome.m_203656_(key)) continue;
                                return true;
                            }
                            return false;
                        }));
                        break;
                    }
                    TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(value.getAsString()));
                    builder.extraCondition((TriFunction<Level, BlockPos, Player, Boolean>)((TriFunction)(level, pos, player) -> level.m_204166_(pos).m_203656_(tag)));
                    break;
                }
                case SEESKY: {
                    boolean seesky = object.getAsJsonPrimitive("seesky").getAsBoolean();
                    builder.extraCondition((TriFunction<Level, BlockPos, Player, Boolean>)((TriFunction)(level, pos, player) -> level.m_46861_(pos) == seesky));
                    break;
                }
                case CAVE: {
                    boolean cave = object.getAsJsonPrimitive("cave").getAsBoolean();
                    builder.extraCondition((TriFunction<Level, BlockPos, Player, Boolean>)((TriFunction)(level, pos, player) -> GenericRuleEvaluator.checkCave((LevelAccessor)level, pos) == cave));
                    break;
                }
                case STRUCTURE: {
                    HashSet<Object> keys;
                    JsonElement value = object.get(attr);
                    if (value.isJsonArray()) {
                        keys = new HashSet();
                        for (JsonElement element : value.getAsJsonArray()) {
                            keys.add(element.getAsString());
                        }
                        builder.extraCondition((TriFunction<Level, BlockPos, Player, Boolean>)((TriFunction)(level, pos, player) -> {
                            for (String key : keys) {
                                if (!StructureCache.CACHE.isInStructure((LevelAccessor)level, key, (BlockPos)pos)) continue;
                                return true;
                            }
                            return false;
                        }));
                        break;
                    }
                    String structure = value.getAsString();
                    builder.extraCondition((TriFunction<Level, BlockPos, Player, Boolean>)((TriFunction)(level, pos, player) -> StructureCache.CACHE.isInStructure((LevelAccessor)level, structure, (BlockPos)pos)));
                    break;
                }
                case HASSTRUCTURE: {
                    boolean hasstructure = object.getAsJsonPrimitive("hasstructure").getAsBoolean();
                    builder.extraCondition((TriFunction<Level, BlockPos, Player, Boolean>)((TriFunction)(level, pos, player) -> StructureCache.CACHE.isInAnyStructure((LevelAccessor)level, (BlockPos)pos) == hasstructure));
                    break;
                }
                case STRUCTURETAGS: {
                    ResourceLocation key2;
                    JsonElement value = object.get(attr);
                    HashSet<TagKey> tagSet = new HashSet<TagKey>();
                    if (value.isJsonArray()) {
                        for (JsonElement element : value.getAsJsonArray()) {
                            key2 = new ResourceLocation(element.getAsString());
                            TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)key2);
                            tagSet.add(tag);
                        }
                    } else {
                        ResourceLocation key4 = new ResourceLocation(value.getAsString());
                        TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)key4);
                        tagSet.add(tag);
                    }
                    builder.extraCondition((TriFunction<Level, BlockPos, Player, Boolean>)((TriFunction)(level, pos, player) -> {
                        ChunkAccess chunk = level.m_46865_(pos);
                        Map references = chunk.m_62769_();
                        for (Map.Entry e : references.entrySet()) {
                            LongSet longs = (LongSet)e.getValue();
                            if (longs.isEmpty()) continue;
                            Structure struct = (Structure)e.getKey();
                            Optional resourceKey = level.m_9598_().m_175515_(Registries.f_256944_).m_7854_((Object)struct);
                            if (!resourceKey.isPresent()) continue;
                            Holder.Reference holder = (Holder.Reference)level.m_9598_().m_175515_(Registries.f_256944_).m_203636_((ResourceKey)resourceKey.get()).get();
                            for (TagKey tagKey : tagSet) {
                                if (!holder.m_203656_(tagKey)) continue;
                                return true;
                            }
                        }
                        return false;
                    }));
                    break;
                }
                case INCITY: {
                    if (!ModSetup.lostcities) {
                        ErrorHandler.error("Lost Cities condition specified but Lost Cities mod is not loaded!");
                        return;
                    }
                    boolean incity = object.getAsJsonPrimitive("incity").getAsBoolean();
                    builder.extraCondition((TriFunction<Level, BlockPos, Player, Boolean>)((TriFunction)(level, pos, player) -> LostCitySupport.isCity(level, pos) == incity));
                    break;
                }
                case INBUILDING: {
                    if (!ModSetup.lostcities) {
                        ErrorHandler.error("Lost Cities condition specified but Lost Cities mod is not loaded!");
                        return;
                    }
                    boolean inbuilding = object.getAsJsonPrimitive("inbuilding").getAsBoolean();
                    builder.extraCondition((TriFunction<Level, BlockPos, Player, Boolean>)((TriFunction)(level, pos, player) -> LostCitySupport.isBuilding(level, pos) == inbuilding));
                    break;
                }
                case INMULTIBUILDING: {
                    if (!ModSetup.lostcities) {
                        ErrorHandler.error("Lost Cities condition specified but Lost Cities mod is not loaded!");
                        return;
                    }
                    boolean inmultibuilding = object.getAsJsonPrimitive("inmultibuilding").getAsBoolean();
                    builder.extraCondition((TriFunction<Level, BlockPos, Player, Boolean>)((TriFunction)(level, pos, player) -> LostCitySupport.isMultiBuilding(level, pos) == inmultibuilding));
                    break;
                }
                case BUILDING: {
                    if (!ModSetup.lostcities) {
                        ErrorHandler.error("Lost Cities condition specified but Lost Cities mod is not loaded!");
                        return;
                    }
                    JsonElement value = object.get(attr);
                    HashSet<Object> keys = new HashSet<Object>();
                    if (value.isJsonArray()) {
                        for (JsonElement element : value.getAsJsonArray()) {
                            keys.add(element.getAsString());
                        }
                    } else {
                        keys.add(value.getAsString());
                    }
                    builder.extraCondition((TriFunction<Level, BlockPos, Player, Boolean>)((TriFunction)(level, pos, player) -> {
                        String building = LostCitySupport.getBuildingName(level, pos);
                        return keys.contains(building);
                    }));
                    break;
                }
                case MULTIBUILDING: {
                    if (!ModSetup.lostcities) {
                        ErrorHandler.error("Lost Cities condition specified but Lost Cities mod is not loaded!");
                        return;
                    }
                    JsonElement value = object.get(attr);
                    HashSet<Object> keys = new HashSet();
                    if (value.isJsonArray()) {
                        for (JsonElement element : value.getAsJsonArray()) {
                            keys.add(element.getAsString());
                        }
                    } else {
                        keys.add(value.getAsString());
                    }
                    builder.extraCondition((TriFunction<Level, BlockPos, Player, Boolean>)((TriFunction)(level, pos, player) -> {
                        String building = LostCitySupport.getMultiBuildingName(level, pos);
                        return keys.contains(building);
                    }));
                    break;
                }
                case INSTREET: {
                    if (!ModSetup.lostcities) {
                        ErrorHandler.error("Lost Cities condition specified but Lost Cities mod is not loaded!");
                        return;
                    }
                    boolean instreet = object.getAsJsonPrimitive("instreet").getAsBoolean();
                    builder.extraCondition((TriFunction<Level, BlockPos, Player, Boolean>)((TriFunction)(level, pos, player) -> LostCitySupport.isStreet(level, pos) == instreet));
                    break;
                }
                case INSPHERE: {
                    if (!ModSetup.lostcities) {
                        ErrorHandler.error("Lost Cities condition specified but Lost Cities mod is not loaded!");
                        return;
                    }
                    boolean inspere = object.getAsJsonPrimitive("inspere").getAsBoolean();
                    builder.extraCondition((TriFunction<Level, BlockPos, Player, Boolean>)((TriFunction)(level, pos, player) -> LostCitySupport.inSphere(level, pos) == inspere));
                    break;
                }
                case GAMESTAGE: {
                    HashSet<Object> keys;
                    if (!ModSetup.gamestages) {
                        ErrorHandler.error("Game Stages condition specified but Game Stages mod is not loaded!");
                        return;
                    }
                    JsonElement value = object.get(attr);
                    if (value.isJsonArray()) {
                        keys = new HashSet();
                        for (JsonElement element : value.getAsJsonArray()) {
                            keys.add(element.getAsString());
                        }
                        builder.extraCondition((TriFunction<Level, BlockPos, Player, Boolean>)((TriFunction)(level, pos, player) -> {
                            for (String key : keys) {
                                if (!GameStageSupport.hasGameStage(player, key)) continue;
                                return true;
                            }
                            return false;
                        }));
                        break;
                    }
                    String gamestage = value.getAsString();
                    builder.extraCondition((TriFunction<Level, BlockPos, Player, Boolean>)((TriFunction)(level, pos, player) -> GameStageSupport.hasGameStage(player, gamestage)));
                    break;
                }
                case SUMMER: {
                    if (!ModSetup.sereneSeasons) {
                        ErrorHandler.error("Serene Seasons condition specified but Serene Seasons mod is not loaded!");
                        return;
                    }
                    boolean summer = object.getAsJsonPrimitive("summer").getAsBoolean();
                    builder.extraCondition((TriFunction<Level, BlockPos, Player, Boolean>)((TriFunction)(level, pos, player) -> SereneSeasonsSupport.isSummer(level) == summer));
                    break;
                }
                case WINTER: {
                    if (!ModSetup.sereneSeasons) {
                        ErrorHandler.error("Serene Seasons condition specified but Serene Seasons mod is not loaded!");
                        return;
                    }
                    boolean winter = object.getAsJsonPrimitive("winter").getAsBoolean();
                    builder.extraCondition((TriFunction<Level, BlockPos, Player, Boolean>)((TriFunction)(level, pos, player) -> SereneSeasonsSupport.isWinter(level) == winter));
                    break;
                }
                case SPRING: {
                    if (!ModSetup.sereneSeasons) {
                        ErrorHandler.error("Serene Seasons condition specified but Serene Seasons mod is not loaded!");
                        return;
                    }
                    boolean spring = object.getAsJsonPrimitive("spring").getAsBoolean();
                    builder.extraCondition((TriFunction<Level, BlockPos, Player, Boolean>)((TriFunction)(level, pos, player) -> SereneSeasonsSupport.isSpring(level) == spring));
                    break;
                }
                case AUTUMN: {
                    if (!ModSetup.sereneSeasons) {
                        ErrorHandler.error("Serene Seasons condition specified but Serene Seasons mod is not loaded!");
                        return;
                    }
                    boolean autumn = object.getAsJsonPrimitive("autumn").getAsBoolean();
                    builder.extraCondition((TriFunction<Level, BlockPos, Player, Boolean>)((TriFunction)(level, pos, player) -> SereneSeasonsSupport.isAutumn(level) == autumn));
                }
            }
        }
    }

    static {
        for (Cmd cmd : Cmd.values()) {
            CONDITIONS.put(cmd.name().toLowerCase(), cmd);
        }
    }

    public static class Builder {
        private final BiFunction<TriFunction<Level, BlockPos, Player, Boolean>, TriFunction<Level, BlockPos, Player, Boolean>, TriFunction<Level, BlockPos, Player, Boolean>> combiner;
        private TriFunction<Level, BlockPos, Player, Boolean> extraConditions = null;

        public Builder(BiFunction<TriFunction<Level, BlockPos, Player, Boolean>, TriFunction<Level, BlockPos, Player, Boolean>, TriFunction<Level, BlockPos, Player, Boolean>> combiner) {
            this.combiner = combiner;
        }

        public Builder extraCondition(TriFunction<Level, BlockPos, Player, Boolean> extraCondition) {
            if (this.extraConditions == null) {
                this.extraConditions = extraCondition;
            } else {
                TriFunction<Level, BlockPos, Player, Boolean> oldCondition = this.extraConditions;
                this.extraConditions = this.combiner.apply(oldCondition, extraCondition);
            }
            return this;
        }

        public PositionCheck build(boolean defaultIfNone) {
            return new PositionCheck(this, defaultIfNone);
        }
    }

    static enum Cmd {
        MINTIME,
        MAXTIME,
        MINLIGHT,
        MAXLIGHT,
        MINLIGHT_FULL,
        MAXLIGHT_FULL,
        BIOME,
        BIOMETAGS,
        SEESKY,
        CAVE,
        STRUCTURE,
        HASSTRUCTURE,
        STRUCTURETAGS,
        INCITY,
        INBUILDING,
        INMULTIBUILDING,
        BUILDING,
        MULTIBUILDING,
        INSTREET,
        INSPHERE,
        GAMESTAGE,
        SUMMER,
        WINTER,
        SPRING,
        AUTUMN;

    }
}

