/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.machines;

import earth.terrarium.adastra.api.systems.GravityApi;
import earth.terrarium.adastra.client.AdAstraClient;
import earth.terrarium.adastra.client.config.AdAstraConfigClient;
import earth.terrarium.adastra.common.blockentities.base.EnergyContainerMachineBlockEntity;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.Configuration;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationEntry;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationType;
import earth.terrarium.adastra.common.blocks.machines.GravityNormalizerBlock;
import earth.terrarium.adastra.common.config.MachineConfig;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.menus.machines.GravityNormalizerMenu;
import earth.terrarium.adastra.common.registry.ModSoundEvents;
import earth.terrarium.adastra.common.utils.TransferUtils;
import earth.terrarium.adastra.common.utils.floodfill.FloodFill3D;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.InsertOnlyEnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedBlockEnergyContainer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class GravityNormalizerBlockEntity
extends EnergyContainerMachineBlockEntity {
    public static final List<ConfigurationEntry> SIDE_CONFIG = List.of(new ConfigurationEntry(ConfigurationType.ENERGY, Configuration.NONE, ConstantComponents.SIDE_CONFIG_ENERGY));
    private final Set<BlockPos> lastDistributedBlocks = new HashSet<BlockPos>();
    private long energyPerTick;
    private int distributedBlocksCount;
    private int shutDownTicks;
    private int limit = MachineConfig.maxDistributionBlocks;
    private boolean shouldSyncPositions;
    private float targetGravity = 1.0f;
    private float animation;
    private float lastAnimation;

    public GravityNormalizerBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state, 1);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("LastDistributedBlocks")) {
            this.lastDistributedBlocks.clear();
            for (long pos : tag.m_128467_("LastDistributedBlocks")) {
                this.lastDistributedBlocks.add(BlockPos.m_122022_((long)pos));
            }
        }
        this.energyPerTick = tag.m_128454_("EnergyPerTick");
        this.distributedBlocksCount = tag.m_128451_("DistributedBlocksCount");
        this.limit = tag.m_128451_("Limit");
        this.targetGravity = tag.m_128457_("TargetGravity");
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128356_("EnergyPerTick", this.energyPerTick);
        tag.m_128405_("DistributedBlocksCount", this.distributedBlocksCount);
        tag.m_128405_("Limit", this.limit);
        tag.m_128350_("TargetGravity", this.targetGravity);
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new GravityNormalizerMenu(id, inventory, this);
    }

    public WrappedBlockEnergyContainer getEnergyStorage() {
        if (this.energyContainer != null) {
            return this.energyContainer;
        }
        this.energyContainer = new WrappedBlockEnergyContainer((BlockEntity)this, (EnergyContainer)new InsertOnlyEnergyContainer(MachineConfig.deshTierEnergyCapacity, MachineConfig.deshTierMaxEnergyInOut));
        return this.energyContainer;
    }

    @Override
    public void serverTick(ServerLevel level, long time, BlockState state, BlockPos pos) {
        super.serverTick(level, time, state, pos);
        if (this.shutDownTicks > 0) {
            --this.shutDownTicks;
            return;
        }
        boolean canDistribute = this.canCraftDistribution();
        if (this.canFunction() && canDistribute) {
            this.getEnergyStorage().internalExtract(this.calculateEnergyPerTick(), false);
            this.setLit(true);
            if (time % (long)MachineConfig.distributionRefreshRate == 0L) {
                this.tickGravity(level, pos, state);
            }
            if (time % 200L == 0L) {
                level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.GRAVITY_NORMALIZER_IDLE.get(), SoundSource.BLOCKS, 0.3f, 1.0f);
            }
        } else if (!this.lastDistributedBlocks.isEmpty()) {
            this.clearGravityBlocks();
            this.shutDownTicks = 60;
            this.setLit(false);
        } else if (time % 10L == 0L) {
            this.setLit(false);
        }
        this.energyPerTick = canDistribute ? this.calculateEnergyPerTick() : 0L;
        this.distributedBlocksCount = canDistribute ? this.lastDistributedBlocks.size() : 0;
    }

    @Override
    public void tickSideInteractions(BlockPos pos, Predicate<Direction> filter, List<ConfigurationEntry> sideConfig) {
        TransferUtils.pullEnergyNearby(this, pos, this.getEnergyStorage().maxInsert(), sideConfig.get(0), filter);
    }

    @Override
    public void onRemoved() {
        this.clearGravityBlocks();
    }

    private boolean canCraftDistribution() {
        long energy = this.calculateEnergyPerTick();
        return this.getEnergyStorage().internalExtract(energy, true) >= energy;
    }

    protected void tickGravity(ServerLevel level, BlockPos pos, BlockState state) {
        this.limit = MachineConfig.maxDistributionBlocks;
        Direction offset = switch ((AttachFace)state.m_61143_((Property)GravityNormalizerBlock.FACE)) {
            case AttachFace.FLOOR -> Direction.UP;
            case AttachFace.CEILING -> Direction.DOWN;
            default -> (Direction)state.m_61143_((Property)GravityNormalizerBlock.FACING);
        };
        Set<BlockPos> positions = FloodFill3D.run((Level)level, pos.m_121945_(offset), this.limit, FloodFill3D.TEST_FULL_SEAL, false);
        GravityApi.API.setGravity((Level)level, positions, this.targetGravity);
        this.resetLastDistributedBlocks(positions);
    }

    protected void resetLastDistributedBlocks(Set<BlockPos> positions) {
        this.lastDistributedBlocks.removeAll(positions);
        this.clearGravityBlocks();
        this.lastDistributedBlocks.addAll(positions);
        this.shouldSyncPositions = true;
    }

    protected void clearGravityBlocks() {
        GravityApi.API.removeGravity(this.f_58857_, this.lastDistributedBlocks);
        this.lastDistributedBlocks.clear();
    }

    @Override
    public void clientTick(ClientLevel level, long time, BlockState state, BlockPos pos) {
        if (time % 40L == 0L) {
            if (AdAstraConfigClient.showGravityNormalizerArea) {
                AdAstraClient.GRAVITY_OVERLAY_RENDERER.removePositions(pos);
                if (AdAstraClient.GRAVITY_OVERLAY_RENDERER.canAdd(pos) && this.canFunction() && this.canCraftDistribution()) {
                    AdAstraClient.GRAVITY_OVERLAY_RENDERER.addPositions(pos, this.lastDistributedBlocks);
                }
            } else {
                AdAstraClient.GRAVITY_OVERLAY_RENDERER.clearPositions();
            }
        }
        this.lastAnimation = this.animation;
        if (this.isLit()) {
            this.animation += 10.0f;
        }
    }

    public int distributedBlocksCount() {
        return this.canFunction() ? this.distributedBlocksCount : 0;
    }

    public int distributedBlocksLimit() {
        return this.limit;
    }

    public long energyPerTick() {
        return this.canFunction() ? this.energyPerTick : 0L;
    }

    public float targetGravity() {
        return this.targetGravity;
    }

    public void setTargetGravity(float targetGravity) {
        this.targetGravity = targetGravity;
    }

    public float animation() {
        return this.animation;
    }

    public float lastAnimation() {
        return this.lastAnimation;
    }

    private long calculateEnergyPerTick() {
        return Math.max(1, this.lastDistributedBlocks.size() / 24);
    }

    @Override
    public List<ConfigurationEntry> getDefaultConfig() {
        return SIDE_CONFIG;
    }

    public int @NotNull [] m_7071_(@NotNull Direction side) {
        return new int[0];
    }

    @Override
    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        if (this.shouldSyncPositions) {
            tag.m_128388_("LastDistributedBlocks", this.lastDistributedBlocks.stream().mapToLong(BlockPos::m_121878_).toArray());
            this.shouldSyncPositions = false;
        }
        return tag;
    }
}

