/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.items.machines;

import earth.terrarium.adastra.common.blockentities.machines.EnergizerBlockEntity;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.utils.TooltipUtils;
import earth.terrarium.botarium.common.energy.base.BotariumEnergyItem;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.SimpleEnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedItemEnergyContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergizerBlockItem
extends BlockItem
implements BotariumEnergyItem<WrappedItemEnergyContainer> {
    public EnergizerBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    protected boolean m_7274_(BlockPos pos, Level level, Player player, ItemStack stack, BlockState state) {
        BlockEntity blockEntity;
        if (level.m_5776_() || !((blockEntity = level.m_7702_(pos)) instanceof EnergizerBlockEntity)) {
            return super.m_7274_(pos, level, player, stack, state);
        }
        EnergizerBlockEntity entity = (EnergizerBlockEntity)blockEntity;
        ItemStackHolder holder = new ItemStackHolder(stack);
        EnergyContainer itemEnergyContainer = EnergyContainer.of((ItemStackHolder)holder);
        if (itemEnergyContainer == null) {
            return super.m_7274_(pos, level, player, stack, state);
        }
        entity.getEnergyStorage().setEnergy(itemEnergyContainer.getStoredEnergy());
        entity.onEnergyChange();
        return super.m_7274_(pos, level, player, stack, state);
    }

    public WrappedItemEnergyContainer getEnergyStorage(ItemStack holder) {
        return new WrappedItemEnergyContainer(holder, (EnergyContainer)new SimpleEnergyContainer(2000000L){

            public long maxInsert() {
                return 1000L;
            }

            public long maxExtract() {
                return 1000L;
            }
        });
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return this.getEnergyStorage(stack).getStoredEnergy() > 0L;
    }

    public int m_142158_(@NotNull ItemStack stack) {
        WrappedItemEnergyContainer energyStorage = this.getEnergyStorage(stack);
        return (int)((double)energyStorage.getStoredEnergy() / (double)energyStorage.getMaxCapacity() * 13.0);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return 6544578;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        WrappedItemEnergyContainer energy = this.getEnergyStorage(stack);
        tooltipComponents.add(TooltipUtils.getEnergyComponent(energy.getStoredEnergy(), energy.getMaxCapacity()));
        tooltipComponents.add(TooltipUtils.getMaxEnergyInComponent(energy.maxInsert()));
        tooltipComponents.add(TooltipUtils.getMaxEnergyOutComponent(energy.maxExtract()));
        TooltipUtils.addDescriptionComponent(tooltipComponents, ConstantComponents.ENERGIZER_INFO);
    }
}

