/*
 * Decompiled with CFR 0.152.
 */
package com.cinemamod.mcef;

import org.cef.callback.CefDragData;
import org.cef.misc.CefCursorType;

public class MCEFDragContext {
    private CefDragData dragData = null;
    private int dragMask = 0;
    private int cursorOverride = -1;
    private int actualCursor = -1;

    public int getVirtualModifiers(int btnMask) {
        return this.dragData != null ? 0 : btnMask;
    }

    public int getVirtualCursor(int cursorType) {
        this.actualCursor = cursorType;
        if (this.cursorOverride != -1) {
            cursorType = this.cursorOverride;
        }
        return cursorType;
    }

    public boolean isDragging() {
        return this.dragData != null;
    }

    public CefDragData getDragData() {
        return this.dragData;
    }

    public int getMask() {
        return this.dragMask;
    }

    public int getActualCursor() {
        return this.actualCursor;
    }

    public void startDragging(CefDragData dragData, int mask) {
        this.dragData = dragData;
        this.dragMask = mask;
    }

    public void stopDragging() {
        this.dragData.dispose();
        this.dragData = null;
        this.dragMask = 0;
        this.cursorOverride = -1;
    }

    public boolean updateCursor(int operation) {
        if (this.dragData == null) {
            return false;
        }
        int currentOverride = this.cursorOverride;
        switch (operation) {
            case 0: {
                this.cursorOverride = CefCursorType.NO_DROP.ordinal();
                break;
            }
            case 1: {
                this.cursorOverride = CefCursorType.COPY.ordinal();
                break;
            }
            case 16: {
                this.cursorOverride = CefCursorType.MOVE.ordinal();
                break;
            }
            default: {
                this.cursorOverride = -1;
            }
        }
        return currentOverride != this.cursorOverride && this.cursorOverride != -1;
    }
}

