/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.reactor;

import com.brandon3055.brandonscore.blocks.EntityBlockBCore;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.init.DEContent;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class ReactorCore
extends EntityBlockBCore {
    private static final VoxelShape NO_AABB = Shapes.m_83048_((double)0.5, (double)0.5, (double)0.5, (double)0.5, (double)0.5, (double)0.5);
    private static final VoxelShape AABB = Shapes.m_83048_((double)0.25, (double)0.25, (double)0.25, (double)0.75, (double)0.75, (double)0.75);

    public ReactorCore(BlockBehaviour.Properties properties) {
        super(properties);
        this.setBlockEntity(() -> DEContent.TILE_REACTOR_CORE.get(), true);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof TileReactorCore) {
            TileReactorCore core = (TileReactorCore)blockEntity;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (player.m_150110_().f_35937_) {
                    NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)core, (BlockPos)pos);
                }
            }
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public float getExplosionResistance(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof TileReactorCore) {
            TileReactorCore tile = (TileReactorCore)blockEntity;
            return ((TileReactorCore.ReactorState)tile.reactorState.get()).isShieldActive() ? 6000000.0f : super.getExplosionResistance(state, world, pos, explosion);
        }
        return super.getExplosionResistance(state, world, pos, explosion);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof TileReactorCore) {
            TileReactorCore tile = (TileReactorCore)blockEntity;
            return ((TileReactorCore.ReactorState)tile.reactorState.get()).isShieldActive() ? -1.0f : super.m_5880_(state, player, world, pos);
        }
        return super.m_5880_(state, player, world, pos);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof TileReactorCore) {
            TileReactorCore tile = (TileReactorCore)blockEntity;
            if (((TileReactorCore.ReactorState)tile.reactorState.get()).isShieldActive()) {
                return;
            }
        }
        super.onBlockExploded(state, world, pos, explosion);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return Shapes.m_83144_();
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return Shapes.m_83144_();
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83144_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    protected void m_142387_(Level level, Player player, BlockPos pos, BlockState state) {
        level.m_5898_(player, 2001, pos, ReactorCore.m_49956_((BlockState)state));
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel worldserver, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return true;
    }

    public boolean addRunningEffects(BlockState state, Level world, BlockPos pos, Entity entity) {
        return true;
    }
}

