/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.client.particle.IntParticleType;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.brandonscore.lib.datamanager.ManagedPos;
import com.brandon3055.brandonscore.utils.FacingUtils;
import com.brandon3055.draconicevolution.blocks.StructureBlock;
import com.brandon3055.draconicevolution.blocks.machines.EnergyCoreStabilizer;
import com.brandon3055.draconicevolution.blocks.tileentity.MultiBlockController;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCore;
import com.brandon3055.draconicevolution.blocks.tileentity.TileStructureBlock;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class TileEnergyCoreStabilizer
extends TileBCore
implements IInteractTile,
MultiBlockController {
    public final ManagedPos coreOffset = (ManagedPos)this.register((IManagedData)new ManagedPos("core_offset", (BlockPos)null, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedBool isCoreActive = (ManagedBool)this.register((IManagedData)new ManagedBool("is_core_active", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedBool isValidMultiBlock = (ManagedBool)this.register((IManagedData)new ManagedBool("is_valid_multi_block", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public final ManagedEnum<Direction.Axis> multiBlockAxis = (ManagedEnum)this.register((IManagedData)new ManagedEnum("multi_block_axis", (Enum)Direction.Axis.Y, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public final ManagedEnum<Direction> coreDirection = (ManagedEnum)this.register((IManagedData)new ManagedEnum("core_direction", (Enum)Direction.DOWN, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public float rotation = 0.0f;
    public float rotationSpeed = 0.0f;
    private boolean moveCheckComplete = false;

    public TileEnergyCoreStabilizer(BlockPos pos, BlockState state) {
        super((BlockEntityType)DEContent.TILE_CORE_STABILIZER.get(), pos, state);
    }

    @Override
    public InteractionResult handleRemoteClick(Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.f_58857_.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        TileEnergyCore core = this.getCore();
        if (core == null) {
            core = this.findCore();
        }
        if (core != null) {
            core.handleRemoteClick(player, hand, hit);
        } else {
            player.m_213846_((Component)Component.m_237115_((String)"msg.draconicevolution.energy_core.core_not_found").m_130940_(ChatFormatting.DARK_RED));
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onBlockUse(BlockState state, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.handleRemoteClick(player, hand, hit);
    }

    public void onPlaced() {
        if (this.f_58857_.f_46443_ || this.checkAndFormMultiBlock()) {
            return;
        }
        for (BlockPos offset : FacingUtils.AROUND_ALL) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121955_((Vec3i)offset));
            if (!(blockEntity instanceof TileEnergyCoreStabilizer) || !((TileEnergyCoreStabilizer)blockEntity).checkAndFormMultiBlock()) continue;
            return;
        }
    }

    private boolean checkAndFormMultiBlock() {
        TileEnergyCore core = this.getCore();
        if (core != null && core.active.get()) {
            return false;
        }
        for (Direction.Axis axis : Direction.Axis.values()) {
            if (!this.checkAxisValid(axis)) continue;
            this.buildMultiBlock(axis);
            return true;
        }
        return false;
    }

    private boolean checkAxisValid(Direction.Axis axis) {
        for (BlockPos offset : FacingUtils.getAroundAxis((Direction.Axis)axis)) {
            if (this.isAvailable(this.f_58858_.m_121955_((Vec3i)offset))) continue;
            return false;
        }
        return true;
    }

    private boolean isAvailable(BlockPos pos) {
        BlockEntity tile = this.f_58857_.m_7702_(pos);
        if (this.isValidMultiBlock.get()) {
            return tile instanceof TileStructureBlock && ((TileStructureBlock)tile).getController() == this;
        }
        return tile instanceof TileEnergyCoreStabilizer && (((TileEnergyCoreStabilizer)tile).getCore() == null || !((TileEnergyCoreStabilizer)tile).getCore().active.get());
    }

    private void buildMultiBlock(Direction.Axis axis) {
        this.coreOffset.set(null);
        StructureBlock.buildingLock = true;
        for (BlockPos offset : FacingUtils.getAroundAxis((Direction.Axis)axis)) {
            this.f_58857_.m_46597_(this.f_58858_.m_121955_((Vec3i)offset), ((StructureBlock)((Object)DEContent.STRUCTURE_BLOCK.get())).m_49966_());
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121955_((Vec3i)offset));
            if (!(blockEntity instanceof TileStructureBlock)) continue;
            TileStructureBlock tile = (TileStructureBlock)blockEntity;
            tile.blockName.set(DEContent.ENERGY_CORE_STABILIZER.getId());
            tile.setController(this);
        }
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)EnergyCoreStabilizer.LARGE, (Comparable)Boolean.valueOf(true)));
        this.isValidMultiBlock.set(true);
        this.multiBlockAxis.set((Enum)axis);
        StructureBlock.buildingLock = false;
    }

    @Override
    public boolean validateStructure() {
        TileEnergyCore core;
        if (this.checkAxisValid((Direction.Axis)this.multiBlockAxis.get())) {
            return true;
        }
        this.revertStructure();
        if (this.isCoreActive.get() && ((core = this.getCore()) == null || !core.active.get())) {
            this.isCoreActive.set(false);
        }
        return false;
    }

    @Override
    public boolean isStructureValid() {
        return this.isValidMultiBlock.get();
    }

    public boolean isSuitableForCore(int coreTier, TileEnergyCore core) {
        if (coreTier < 5 && !this.isValidMultiBlock.get()) {
            return true;
        }
        if (coreTier >= 5 && this.isValidMultiBlock.get()) {
            BlockPos offset = this.f_58858_.m_121996_((Vec3i)core.m_58899_());
            Direction direction = Direction.m_122372_((float)offset.m_123341_(), (float)offset.m_123342_(), (float)offset.m_123343_()).m_122424_();
            return direction.m_122434_() == this.multiBlockAxis.get();
        }
        return false;
    }

    public void revertStructure() {
        if (this.f_58857_.m_8055_(this.f_58858_).m_60713_((Block)DEContent.ENERGY_CORE_STABILIZER.get())) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)EnergyCoreStabilizer.LARGE, (Comparable)Boolean.valueOf(false)));
        }
        this.isValidMultiBlock.set(false);
        if (this.getCore() != null) {
            this.getCore().deactivateCore();
        }
        for (BlockPos offset : FacingUtils.getAroundAxis((Direction.Axis)((Direction.Axis)this.multiBlockAxis.get()))) {
            BlockEntity tile = this.f_58857_.m_7702_(this.f_58858_.m_121955_((Vec3i)offset));
            if (!(tile instanceof TileStructureBlock)) continue;
            ((TileStructureBlock)tile).revert();
        }
    }

    public TileEnergyCore findCore() {
        if (this.getCore() != null) {
            return this.getCore();
        }
        for (Direction facing : Direction.values()) {
            for (int i = 0; i < 16; ++i) {
                BlockEntity tile = this.f_58857_.m_7702_(this.f_58858_.m_7918_(facing.m_122429_() * i, facing.m_122430_() * i, facing.m_122431_() * i));
                if (!(tile instanceof TileEnergyCore)) continue;
                TileEnergyCore core = (TileEnergyCore)tile;
                core.validateStructure();
                if (core.active.get()) continue;
                return core;
            }
        }
        return null;
    }

    public TileEnergyCore getCore() {
        BlockPos corePos = this.getCorePos();
        if (corePos != null) {
            BlockEntity tile = this.f_58857_.m_7702_(corePos);
            if (tile instanceof TileEnergyCore) {
                return (TileEnergyCore)tile;
            }
            this.coreOffset.set(null);
        }
        return null;
    }

    @Nullable
    private BlockPos getCorePos() {
        return this.coreOffset.get() == null ? null : this.f_58858_.m_121996_((Vec3i)Objects.requireNonNull(this.coreOffset.get()));
    }

    public void setCore(@Nullable TileEnergyCore core) {
        if (core == null) {
            this.coreOffset.set(null);
            return;
        }
        BlockPos offset = this.f_58858_.m_121996_((Vec3i)core.m_58899_());
        this.coreOffset.set(offset);
        this.coreDirection.set((Enum)Direction.m_122372_((float)offset.m_123341_(), (float)offset.m_123342_(), (float)offset.m_123343_()).m_122424_());
    }

    @Override
    public VoxelShape getShapeForPart(BlockPos pos, CollisionContext context) {
        BlockState stabState = this.f_58857_.m_8055_(this.f_58858_);
        if (stabState.m_60713_((Block)DEContent.ENERGY_CORE_STABILIZER.get())) {
            BlockPos offset = this.f_58858_.m_121996_((Vec3i)pos);
            return stabState.m_60734_().m_5940_(stabState, (BlockGetter)this.f_58857_, this.f_58858_, context).m_83216_((double)offset.m_123341_(), (double)offset.m_123342_(), (double)offset.m_123343_());
        }
        return Shapes.m_83144_();
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_ && this.coreOffset.get() != null && this.isCoreActive.get()) {
            this.rotation = TimeKeeper.getClientTick();
            this.updateVisual();
            if (this.isValidMultiBlock.get()) {
                this.updateVisual();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void updateVisual() {
        Vec3D spawn = new Vec3D(this.f_58858_);
        spawn.add(0.5, 0.5, 0.5);
        double rand = (double)this.f_58857_.f_46441_.m_188503_(100) / 12.0;
        double randOffset = rand * (Math.PI * 2);
        double offsetX = Math.sin((double)ClientEventHandler.elapsedTicks / 180.0 * Math.PI + randOffset);
        double offsetY = Math.cos((double)ClientEventHandler.elapsedTicks / 180.0 * Math.PI + randOffset);
        if (!this.isValidMultiBlock.get() || this.f_58857_.f_46441_.m_188499_()) {
            double inset;
            double d = this.isValidMultiBlock.get() ? 1.1 : 0.25;
            double d2 = inset = this.isValidMultiBlock.get() ? 1.0 : 0.0;
            if (((Direction)this.coreDirection.get()).m_122434_() == Direction.Axis.Z) {
                spawn.add(offsetX * d, offsetY * d, (this.f_58857_.f_46441_.m_188499_() ? -0.38 : 0.38) * inset);
            } else if (((Direction)this.coreDirection.get()).m_122434_() == Direction.Axis.Y) {
                spawn.add(offsetX * d, (this.f_58857_.f_46441_.m_188499_() ? -0.38 : 0.38) * inset, offsetY * d);
            } else if (((Direction)this.coreDirection.get()).m_122434_() == Direction.Axis.X) {
                spawn.add((this.f_58857_.f_46441_.m_188499_() ? -0.38 : 0.38) * inset, offsetY * d, offsetX * d);
            }
            Vector3 target = Vector3.fromBlockPosCenter((BlockPos)this.f_58858_).subtract(this.coreOffset.get());
            this.f_58857_.m_7106_((ParticleOptions)new IntParticleType.IntParticleData((ParticleType)DEParticles.ENERGY_CORE.get(), new int[]{1, (int)(randOffset * 100.0), this.isValidMultiBlock.get() ? 1 : 0}), spawn.x, spawn.y, spawn.z, target.x, target.y, target.z);
        } else {
            if (((Direction)this.coreDirection.get()).m_122434_() == Direction.Axis.Z) {
                spawn.add(offsetX * 1.2, offsetY * 1.2, this.f_58857_.f_46441_.m_188499_() ? -0.38 : 0.38);
            } else if (((Direction)this.coreDirection.get()).m_122434_() == Direction.Axis.Y) {
                spawn.add(offsetX * 1.2, this.f_58857_.f_46441_.m_188499_() ? -0.38 : 0.38, offsetY * 1.2);
            } else if (((Direction)this.coreDirection.get()).m_122434_() == Direction.Axis.X) {
                spawn.add(this.f_58857_.f_46441_.m_188499_() ? -0.38 : 0.38, offsetY * 1.2, offsetX * 1.2);
            }
            Vector3 target = Vector3.fromBlockPosCenter((BlockPos)this.f_58858_);
            this.f_58857_.m_7106_((ParticleOptions)new IntParticleType.IntParticleData((ParticleType)DEParticles.ENERGY_CORE.get(), new int[]{0}), spawn.x, spawn.y, spawn.z, target.x, target.y, target.z);
        }
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82377_(1.0, 1.0, 1.0);
    }
}

