/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.entity;

import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.client.DEShaders;
import com.brandon3055.draconicevolution.client.render.entity.GuardianCrystalRenderer;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.control.ChargeUpPhase;
import com.brandon3055.draconicevolution.entity.guardian.control.IPhase;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class DraconicGuardianRenderer
extends EntityRenderer<DraconicGuardianEntity> {
    public static final ResourceLocation ENDERCRYSTAL_BEAM_TEXTURES = new ResourceLocation("draconicevolution", "textures/entity/guardian_crystal_beam.png");
    private static final ResourceLocation DRAGON_EXPLODING_TEXTURES = new ResourceLocation("textures/entity/enderdragon/dragon_exploding.png");
    private static final ResourceLocation DRAGON_TEXTURE = new ResourceLocation("textures/entity/enderdragon/dragon.png");
    private static final ResourceLocation GUARDIAN_TEXTURE = new ResourceLocation("draconicevolution", "textures/entity/chaos_guardian.png");
    private static final ResourceLocation EYES_TEXTURE = new ResourceLocation("textures/entity/enderdragon/dragon_eyes.png");
    private static final RenderType dragonCutoutType = RenderType.m_110458_((ResourceLocation)GUARDIAN_TEXTURE);
    private static final RenderType dragonDeathType = RenderType.m_110479_((ResourceLocation)GUARDIAN_TEXTURE);
    private static final RenderType eyesType = RenderType.m_110488_((ResourceLocation)EYES_TEXTURE);
    private static final RenderType beamType = RenderType.m_110476_((ResourceLocation)ENDERCRYSTAL_BEAM_TEXTURES);
    private static RenderType BEAM_TYPE2 = RenderType.m_173215_((String)"beam_type_2", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderType.f_173067_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ENDERCRYSTAL_BEAM_TEXTURES, false, false)).m_110685_(RenderStateShard.f_110139_).m_110661_(RenderStateShard.f_110110_).m_110691_(false));
    public static RenderType SHIELD_TYPE = RenderType.m_173209_((String)"draconicevolution:guardian_shield", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(() -> DEShaders.shieldShader)).m_110685_(RenderStateShard.f_110139_).m_110671_(RenderStateShard.f_110152_).m_110661_(RenderStateShard.f_110110_).m_110663_(RenderStateShard.f_110112_).m_110691_(false));
    private static final float sqrt3div2 = (float)(Math.sqrt(3.0) / 2.0);
    private final DragonModel model;

    public DraconicGuardianRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.5f;
        this.model = new DragonModel(context.m_174023_(ModelLayers.f_171144_));
    }

    public void render(DraconicGuardianEntity guardian, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource getter, int packedLight) {
        ChargeUpPhase phase;
        IPhase iPhase;
        poseStack.m_85836_();
        float f = (float)guardian.getLatencyPos(7, partialTicks)[0];
        float f1 = (float)(guardian.getLatencyPos(5, partialTicks)[1] - guardian.getLatencyPos(10, partialTicks)[1]);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(f1 * 10.0f));
        poseStack.m_85837_(0.0, 0.0, 1.0);
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_85837_(0.0, (double)-1.501f, 0.0);
        boolean flag = guardian.f_20916_ > 0;
        this.model.prepareMobModel(guardian, 0.0f, 0.0f, partialTicks);
        if (guardian.deathTicks > 0) {
            float progress = (float)guardian.deathTicks / 200.0f;
            VertexConsumer builder = getter.m_6299_(RenderType.m_173235_((ResourceLocation)DRAGON_EXPLODING_TEXTURES));
            this.model.m_7695_(poseStack, builder, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, progress);
            builder = getter.m_6299_(dragonDeathType);
            this.model.m_7695_(poseStack, builder, packedLight, OverlayTexture.m_118090_((float)0.0f, (boolean)flag), 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            VertexConsumer builder = getter.m_6299_(dragonCutoutType);
            this.model.m_7695_(poseStack, builder, packedLight, OverlayTexture.m_118090_((float)0.0f, (boolean)flag), 1.0f, 1.0f, 1.0f, 1.0f);
        }
        boolean isImmune = guardian.getPhaseManager().getCurrentPhase().isInvulnerable();
        float shieldState = ((Float)guardian.m_20088_().m_135370_(DraconicGuardianEntity.SHIELD_POWER)).floatValue() / (float)DEConfig.guardianShield;
        if (shieldState > 0.0f || isImmune) {
            if (isImmune) {
                DEShaders.shieldColour.glUniform4f(0.0f, 1.0f, 1.0f, 2.0f);
            } else {
                DEShaders.shieldColour.glUniform4f(1.0f, 0.0f, 0.0f, 1.5f * shieldState);
            }
            DEShaders.shieldBarMode.glUniform1i(0);
            DEShaders.shieldActivation.glUniform1f(1.0f);
            VertexConsumer builder = getter.m_6299_(SHIELD_TYPE);
            this.model.m_7695_(poseStack, builder, packedLight, OverlayTexture.m_118090_((float)0.0f, (boolean)flag), 1.0f, 1.0f, 1.0f, 1.0f);
        }
        VertexConsumer builder = getter.m_6299_(eyesType);
        this.model.m_7695_(poseStack, builder, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (guardian.deathTicks > 0) {
            float f5 = ((float)guardian.deathTicks + partialTicks) / 200.0f;
            float f7 = Math.min(f5 > 0.8f ? (f5 - 0.8f) / 0.2f : 0.0f, 1.0f);
            Random random = new Random(432L);
            builder = getter.m_6299_(RenderType.m_110502_());
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, -1.0, -2.0);
            int i = 0;
            while ((float)i < (f5 + f5 * f5) / 2.0f * 60.0f) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(random.nextFloat() * 360.0f));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(random.nextFloat() * 360.0f));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(random.nextFloat() * 360.0f));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(random.nextFloat() * 360.0f));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(random.nextFloat() * 360.0f));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(random.nextFloat() * 360.0f + f5 * 90.0f));
                float f3 = random.nextFloat() * 20.0f + 5.0f + f7 * 10.0f;
                float f4 = random.nextFloat() * 2.0f + 1.0f + f7 * 2.0f;
                Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
                int j = (int)(255.0f * (1.0f - f7));
                DraconicGuardianRenderer.deathAnimA(builder, matrix4f, j);
                DraconicGuardianRenderer.deathAnimB(builder, matrix4f, f3, f4);
                DraconicGuardianRenderer.deathAnimC(builder, matrix4f, f3, f4);
                DraconicGuardianRenderer.deathAnimA(builder, matrix4f, j);
                DraconicGuardianRenderer.deathAnimC(builder, matrix4f, f3, f4);
                DraconicGuardianRenderer.deathAnimD(builder, matrix4f, f3, f4);
                DraconicGuardianRenderer.deathAnimA(builder, matrix4f, j);
                DraconicGuardianRenderer.deathAnimD(builder, matrix4f, f3, f4);
                DraconicGuardianRenderer.deathAnimB(builder, matrix4f, f3, f4);
                ++i;
            }
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
        if (guardian.closestGuardianCrystal != null) {
            poseStack.m_85836_();
            float relX = (float)(guardian.closestGuardianCrystal.m_20185_() - Mth.m_14139_((double)partialTicks, (double)guardian.f_19854_, (double)guardian.m_20185_()));
            float relY = (float)(guardian.closestGuardianCrystal.m_20186_() - Mth.m_14139_((double)partialTicks, (double)guardian.f_19855_, (double)guardian.m_20186_()));
            float relZ = (float)(guardian.closestGuardianCrystal.m_20189_() - Mth.m_14139_((double)partialTicks, (double)guardian.f_19856_, (double)guardian.m_20189_()));
            DraconicGuardianRenderer.renderBeam(relX, relY + GuardianCrystalRenderer.getY(guardian.closestGuardianCrystal, partialTicks), relZ, partialTicks, guardian.f_19797_, poseStack, getter, packedLight);
            poseStack.m_85849_();
        }
        if ((iPhase = guardian.getPhaseManager().getCurrentPhase()) instanceof ChargeUpPhase && guardian.getArenaOrigin() != null && (phase = (ChargeUpPhase)iPhase).animState() != 0.0f) {
            BlockPos origin = guardian.getArenaOrigin();
            float beamSin = Mth.m_14031_((float)(phase.animState() * (float)Math.PI));
            poseStack.m_85836_();
            float relX = (float)((double)origin.m_123341_() + 0.5 - Mth.m_14139_((double)partialTicks, (double)guardian.f_19854_, (double)guardian.m_20185_()));
            float relY = (float)((double)origin.m_123342_() + 0.5 - Mth.m_14139_((double)partialTicks, (double)guardian.f_19855_, (double)guardian.m_20186_()));
            float relZ = (float)((double)origin.m_123343_() + 0.5 - Mth.m_14139_((double)partialTicks, (double)guardian.f_19856_, (double)guardian.m_20189_()));
            DraconicGuardianRenderer.renderChargingBeam(relX, relY, relZ, partialTicks, guardian.f_19797_, poseStack, getter, packedLight, beamSin);
            poseStack.m_85849_();
        }
        super.m_7392_((Entity)guardian, entityYaw, partialTicks, poseStack, getter, packedLight);
    }

    private static void deathAnimA(VertexConsumer builder, Matrix4f mat, int alpha) {
        builder.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_6122_(255, 0, 0, alpha).m_5752_();
        builder.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_6122_(255, 0, 0, alpha).m_5752_();
    }

    private static void deathAnimB(VertexConsumer builder, Matrix4f mat, float p_229060_2_, float p_229060_3_) {
        builder.m_252986_(mat, -sqrt3div2 * p_229060_3_, p_229060_2_, -0.5f * p_229060_3_).m_6122_(255, 0, 0, 0).m_5752_();
    }

    private static void deathAnimC(VertexConsumer builder, Matrix4f mat, float p_229062_2_, float p_229062_3_) {
        builder.m_252986_(mat, sqrt3div2 * p_229062_3_, p_229062_2_, -0.5f * p_229062_3_).m_6122_(255, 0, 255, 0).m_5752_();
    }

    private static void deathAnimD(VertexConsumer builder, Matrix4f mat, float p_229063_2_, float p_229063_3_) {
        builder.m_252986_(mat, 0.0f, p_229063_2_, 1.0f * p_229063_3_).m_6122_(255, 0, 0, 0).m_5752_();
    }

    public static void renderBeam(float crystalRelX, float crystalRelY, float crystalRelZ, float partialTicks, int animTicks, PoseStack mStack, MultiBufferSource getter, int packedLight) {
        float xzDistance = Mth.m_14116_((float)(crystalRelX * crystalRelX + crystalRelZ * crystalRelZ));
        float distance = Mth.m_14116_((float)(crystalRelX * crystalRelX + crystalRelY * crystalRelY + crystalRelZ * crystalRelZ));
        mStack.m_85836_();
        mStack.m_85837_(0.0, 2.0, 0.0);
        mStack.m_252781_(Axis.f_252436_.m_252961_((float)(-Math.atan2(crystalRelZ, crystalRelX)) - 1.5707964f));
        mStack.m_252781_(Axis.f_252529_.m_252961_((float)(-Math.atan2(xzDistance, crystalRelY)) - 1.5707964f));
        VertexConsumer builder = getter.m_6299_(beamType);
        float f2 = 0.0f - ((float)animTicks + partialTicks) * 0.01f;
        float f3 = Mth.m_14116_((float)(crystalRelX * crystalRelX + crystalRelY * crystalRelY + crystalRelZ * crystalRelZ)) / 32.0f - ((float)animTicks + partialTicks) * 0.01f;
        float f4 = 0.0f;
        float f5 = 0.75f;
        float f6 = 0.0f;
        PoseStack.Pose stackLast = mStack.m_85850_();
        Matrix4f lastMatrix = stackLast.m_252922_();
        Matrix3f lastNormal = stackLast.m_252943_();
        for (int j = 1; j <= 8; ++j) {
            float rSin = Mth.m_14031_((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float rCos = Mth.m_14089_((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float indexDecimal = (float)j / 8.0f;
            builder.m_252986_(lastMatrix, f4 * 0.2f, f5 * 0.2f, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(f6, f2).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(lastNormal, 0.0f, -1.0f, 0.0f).m_5752_();
            builder.m_252986_(lastMatrix, f4, f5, distance).m_6122_(255, 255, 255, 255).m_7421_(f6, f3).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(lastNormal, 0.0f, -1.0f, 0.0f).m_5752_();
            builder.m_252986_(lastMatrix, rSin, rCos, distance).m_6122_(255, 255, 255, 255).m_7421_(indexDecimal, f3).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(lastNormal, 0.0f, -1.0f, 0.0f).m_5752_();
            builder.m_252986_(lastMatrix, rSin * 0.2f, rCos * 0.2f, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(indexDecimal, f2).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(lastNormal, 0.0f, -1.0f, 0.0f).m_5752_();
            f4 = rSin;
            f5 = rCos;
            f6 = indexDecimal;
        }
        mStack.m_85849_();
    }

    public static void renderBeam(float crystalRelX, float crystalRelY, float crystalRelZ, float partialTicks, int animTicks, PoseStack mStack, MultiBufferSource getter, int packedLight, float alpha) {
        float xzDistance = Mth.m_14116_((float)(crystalRelX * crystalRelX + crystalRelZ * crystalRelZ));
        float distance = Mth.m_14116_((float)(crystalRelX * crystalRelX + crystalRelY * crystalRelY + crystalRelZ * crystalRelZ));
        mStack.m_85836_();
        mStack.m_85837_(0.0, 2.0, 0.0);
        mStack.m_252781_(Axis.f_252436_.m_252961_((float)(-Math.atan2(crystalRelZ, crystalRelX)) - 1.5707964f));
        mStack.m_252781_(Axis.f_252529_.m_252961_((float)(-Math.atan2(xzDistance, crystalRelY)) - 1.5707964f));
        VertexConsumer builder = getter.m_6299_(BEAM_TYPE2);
        float f2 = 0.0f - ((float)animTicks + partialTicks) * 0.01f;
        float f3 = Mth.m_14116_((float)(crystalRelX * crystalRelX + crystalRelY * crystalRelY + crystalRelZ * crystalRelZ)) / 32.0f - ((float)animTicks + partialTicks) * 0.01f;
        float f4 = 0.0f;
        float f5 = 0.75f;
        float f6 = 0.0f;
        PoseStack.Pose stackLast = mStack.m_85850_();
        Matrix4f lastMatrix = stackLast.m_252922_();
        Matrix3f lastNormal = stackLast.m_252943_();
        for (int j = 1; j <= 8; ++j) {
            float rSin = Mth.m_14031_((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float rCos = Mth.m_14089_((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float indexDecimal = (float)j / 8.0f;
            builder.m_252986_(lastMatrix, f4 * 0.2f, f5 * 0.2f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(f6, f2).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(lastNormal, 0.0f, -1.0f, 0.0f).m_5752_();
            builder.m_252986_(lastMatrix, f4, f5, distance).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(f6, f3).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(lastNormal, 0.0f, -1.0f, 0.0f).m_5752_();
            builder.m_252986_(lastMatrix, rSin, rCos, distance).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(indexDecimal, f3).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(lastNormal, 0.0f, -1.0f, 0.0f).m_5752_();
            builder.m_252986_(lastMatrix, rSin * 0.2f, rCos * 0.2f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(indexDecimal, f2).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(lastNormal, 0.0f, -1.0f, 0.0f).m_5752_();
            f4 = rSin;
            f5 = rCos;
            f6 = indexDecimal;
        }
        mStack.m_85849_();
    }

    public static void renderChargingBeam(float crystalRelX, float crystalRelY, float crystalRelZ, float partialTicks, int animTicks, PoseStack mStack, MultiBufferSource getter, int packedLight, float alpha) {
        float xzDistance = Mth.m_14116_((float)(crystalRelX * crystalRelX + crystalRelZ * crystalRelZ));
        float distance = Mth.m_14116_((float)(crystalRelX * crystalRelX + crystalRelY * crystalRelY + crystalRelZ * crystalRelZ));
        mStack.m_85836_();
        mStack.m_85837_(0.0, 2.0, 0.0);
        mStack.m_252781_(Axis.f_252436_.m_252961_((float)(-Math.atan2(crystalRelZ, crystalRelX)) - 1.5707964f));
        mStack.m_252781_(Axis.f_252529_.m_252961_((float)(-Math.atan2(xzDistance, crystalRelY)) - 1.5707964f));
        VertexConsumer builder = getter.m_6299_(BEAM_TYPE2);
        float vMin = ((float)animTicks + partialTicks) * 0.01f;
        float vMax = Mth.m_14116_((float)(crystalRelX * crystalRelX + crystalRelY * crystalRelY + crystalRelZ * crystalRelZ)) / 32.0f + ((float)animTicks + partialTicks) * 0.01f;
        float f4 = 0.0f;
        float f5 = 0.1f;
        float texU = 0.0f;
        PoseStack.Pose stackLast = mStack.m_85850_();
        Matrix4f lastMatrix = stackLast.m_252922_();
        Matrix3f lastNormal = stackLast.m_252943_();
        float taperOffset = 10.0f;
        for (int j = 1; j <= 8; ++j) {
            float rSin = Mth.m_14031_((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.1f;
            float rCos = Mth.m_14089_((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.1f;
            float indexDecimal = (float)j / 8.0f;
            builder.m_252986_(lastMatrix, f4 * taperOffset, f5 * taperOffset, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(texU, vMin).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(lastNormal, 0.0f, -1.0f, 0.0f).m_5752_();
            builder.m_252986_(lastMatrix, f4, f5, distance).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(texU, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(lastNormal, 0.0f, -1.0f, 0.0f).m_5752_();
            builder.m_252986_(lastMatrix, rSin, rCos, distance).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(indexDecimal, vMax).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(lastNormal, 0.0f, -1.0f, 0.0f).m_5752_();
            builder.m_252986_(lastMatrix, rSin * taperOffset, rCos * taperOffset, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(indexDecimal, vMin).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(lastNormal, 0.0f, -1.0f, 0.0f).m_5752_();
            f4 = rSin;
            f5 = rCos;
            texU = indexDecimal;
        }
        mStack.m_85849_();
    }

    public static void renderShaderBeam(float crystalRelX, float crystalRelY, float crystalRelZ, float partialTicks, int animTicks, PoseStack mStack, MultiBufferSource getter, int packedLight) {
        float xzDistance = Mth.m_14116_((float)(crystalRelX * crystalRelX + crystalRelZ * crystalRelZ));
        float distance = Mth.m_14116_((float)(crystalRelX * crystalRelX + crystalRelY * crystalRelY + crystalRelZ * crystalRelZ));
        mStack.m_85836_();
        mStack.m_85837_(0.0, 2.0, 0.0);
        mStack.m_252781_(Axis.f_252436_.m_252961_((float)(-Math.atan2(crystalRelZ, crystalRelX)) - 1.5707964f));
        mStack.m_252781_(Axis.f_252529_.m_252961_((float)(-Math.atan2(xzDistance, crystalRelY)) - 1.5707964f));
        VertexConsumer builder = getter.m_6299_(beamType);
        float f2 = 0.0f - ((float)animTicks + partialTicks) * 0.01f;
        float f3 = Mth.m_14116_((float)(crystalRelX * crystalRelX + crystalRelY * crystalRelY + crystalRelZ * crystalRelZ)) / 32.0f - ((float)animTicks + partialTicks) * 0.01f;
        float f4 = 0.0f;
        float f5 = 0.75f;
        float f6 = 0.0f;
        PoseStack.Pose stackLast = mStack.m_85850_();
        Matrix4f lastMatrix = stackLast.m_252922_();
        Matrix3f lastNormal = stackLast.m_252943_();
        for (int j = 1; j <= 8; ++j) {
            float rSin = Mth.m_14031_((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float rCos = Mth.m_14089_((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float indexDecimal = (float)j / 8.0f;
            builder.m_252986_(lastMatrix, f4 * 0.2f, f5 * 0.2f, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(f6, f2).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(lastNormal, 0.0f, -1.0f, 0.0f).m_5752_();
            builder.m_252986_(lastMatrix, f4, f5, distance).m_6122_(255, 255, 255, 255).m_7421_(f6, f3).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(lastNormal, 0.0f, -1.0f, 0.0f).m_5752_();
            builder.m_252986_(lastMatrix, rSin, rCos, distance).m_6122_(255, 255, 255, 255).m_7421_(indexDecimal, f3).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(lastNormal, 0.0f, -1.0f, 0.0f).m_5752_();
            builder.m_252986_(lastMatrix, rSin * 0.2f, rCos * 0.2f, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(indexDecimal, f2).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(lastNormal, 0.0f, -1.0f, 0.0f).m_5752_();
            f4 = rSin;
            f5 = rCos;
            f6 = indexDecimal;
        }
        mStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(DraconicGuardianEntity entity) {
        return DRAGON_TEXTURE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DragonModel
    extends EntityModel<DraconicGuardianEntity> {
        private final ModelPart head;
        private final ModelPart neck;
        private final ModelPart jaw;
        private final ModelPart body;
        private final ModelPart leftWing;
        private final ModelPart leftWingTip;
        private final ModelPart leftFrontLeg;
        private final ModelPart leftFrontLegTip;
        private final ModelPart leftFrontFoot;
        private final ModelPart leftRearLeg;
        private final ModelPart leftRearLegTip;
        private final ModelPart leftRearFoot;
        private final ModelPart rightWing;
        private final ModelPart rightWingTip;
        private final ModelPart rightFrontLeg;
        private final ModelPart rightFrontLegTip;
        private final ModelPart rightFrontFoot;
        private final ModelPart rightRearLeg;
        private final ModelPart rightRearLegTip;
        private final ModelPart rightRearFoot;
        @Nullable
        private DraconicGuardianEntity entity;
        private float a;

        public DragonModel(ModelPart modelPart) {
            this.head = modelPart.m_171324_("head");
            this.jaw = this.head.m_171324_("jaw");
            this.neck = modelPart.m_171324_("neck");
            this.body = modelPart.m_171324_("body");
            this.leftWing = modelPart.m_171324_("left_wing");
            this.leftWingTip = this.leftWing.m_171324_("left_wing_tip");
            this.leftFrontLeg = modelPart.m_171324_("left_front_leg");
            this.leftFrontLegTip = this.leftFrontLeg.m_171324_("left_front_leg_tip");
            this.leftFrontFoot = this.leftFrontLegTip.m_171324_("left_front_foot");
            this.leftRearLeg = modelPart.m_171324_("left_hind_leg");
            this.leftRearLegTip = this.leftRearLeg.m_171324_("left_hind_leg_tip");
            this.leftRearFoot = this.leftRearLegTip.m_171324_("left_hind_foot");
            this.rightWing = modelPart.m_171324_("right_wing");
            this.rightWingTip = this.rightWing.m_171324_("right_wing_tip");
            this.rightFrontLeg = modelPart.m_171324_("right_front_leg");
            this.rightFrontLegTip = this.rightFrontLeg.m_171324_("right_front_leg_tip");
            this.rightFrontFoot = this.rightFrontLegTip.m_171324_("right_front_foot");
            this.rightRearLeg = modelPart.m_171324_("right_hind_leg");
            this.rightRearLegTip = this.rightRearLeg.m_171324_("right_hind_leg_tip");
            this.rightRearFoot = this.rightRearLegTip.m_171324_("right_hind_foot");
        }

        public void prepareMobModel(DraconicGuardianEntity p_114269_, float p_114270_, float p_114271_, float p_114272_) {
            this.entity = p_114269_;
            this.a = p_114272_;
        }

        public void setupAnim(DraconicGuardianEntity p_114274_, float p_114275_, float p_114276_, float p_114277_, float p_114278_, float p_114279_) {
        }

        public void m_7695_(PoseStack p_114281_, VertexConsumer p_114282_, int p_114283_, int p_114284_, float p_114285_, float p_114286_, float p_114287_, float p_114288_) {
            p_114281_.m_85836_();
            float f = Mth.m_14179_((float)this.a, (float)this.entity.oFlapTime, (float)this.entity.flapTime);
            this.jaw.f_104203_ = (float)(Math.sin(f * ((float)Math.PI * 2)) + 1.0) * 0.2f;
            float f1 = (float)(Math.sin(f * ((float)Math.PI * 2) - 1.0f) + 1.0);
            f1 = (f1 * f1 + f1 * 2.0f) * 0.05f;
            p_114281_.m_85837_(0.0, (double)(f1 - 2.0f), -3.0);
            p_114281_.m_252781_(Axis.f_252529_.m_252977_(f1 * 2.0f));
            float f2 = 0.0f;
            float f3 = 20.0f;
            float f4 = -12.0f;
            float f5 = 1.5f;
            double[] adouble = this.entity.getLatencyPos(6, this.a);
            float f6 = Mth.m_14177_((float)((float)this.entity.getLatencyPos(5, this.a)[0] - (float)this.entity.getLatencyPos(10, this.a)[0]));
            float f7 = Mth.m_14177_((float)((float)this.entity.getLatencyPos(5, this.a)[0] + f6 / 2.0f));
            float f8 = f * ((float)Math.PI * 2);
            for (int i = 0; i < 5; ++i) {
                double[] adouble1 = this.entity.getLatencyPos(5 - i, this.a);
                float f9 = (float)Math.cos((float)i * 0.45f + f8) * 0.15f;
                this.neck.f_104204_ = Mth.m_14177_((float)((float)(adouble1[0] - adouble[0]))) * ((float)Math.PI / 180) * 1.5f;
                this.neck.f_104203_ = f9 + this.entity.getHeadPartYOffset(i, adouble, adouble1) * ((float)Math.PI / 180) * 1.5f * 5.0f;
                this.neck.f_104205_ = -Mth.m_14177_((float)((float)(adouble1[0] - (double)f7))) * ((float)Math.PI / 180) * 1.5f;
                this.neck.f_104201_ = f3;
                this.neck.f_104202_ = f4;
                this.neck.f_104200_ = f2;
                f3 += Mth.m_14031_((float)this.neck.f_104203_) * 10.0f;
                f4 -= Mth.m_14089_((float)this.neck.f_104204_) * Mth.m_14089_((float)this.neck.f_104203_) * 10.0f;
                f2 -= Mth.m_14031_((float)this.neck.f_104204_) * Mth.m_14089_((float)this.neck.f_104203_) * 10.0f;
                this.neck.m_104306_(p_114281_, p_114282_, p_114283_, p_114284_, 1.0f, 1.0f, 1.0f, p_114288_);
            }
            this.head.f_104201_ = f3;
            this.head.f_104202_ = f4;
            this.head.f_104200_ = f2;
            double[] adouble2 = this.entity.getLatencyPos(0, this.a);
            this.head.f_104204_ = Mth.m_14177_((float)((float)(adouble2[0] - adouble[0]))) * ((float)Math.PI / 180);
            this.head.f_104203_ = Mth.m_14177_((float)this.entity.getHeadPartYOffset(6, adouble, adouble2)) * ((float)Math.PI / 180) * 1.5f * 5.0f;
            this.head.f_104205_ = -Mth.m_14177_((float)((float)(adouble2[0] - (double)f7))) * ((float)Math.PI / 180);
            this.head.m_104306_(p_114281_, p_114282_, p_114283_, p_114284_, 1.0f, 1.0f, 1.0f, p_114288_);
            p_114281_.m_85836_();
            p_114281_.m_85837_(0.0, 1.0, 0.0);
            p_114281_.m_252781_(Axis.f_252403_.m_252977_(-f6 * 1.5f));
            p_114281_.m_85837_(0.0, -1.0, 0.0);
            this.body.f_104205_ = 0.0f;
            this.body.m_104306_(p_114281_, p_114282_, p_114283_, p_114284_, 1.0f, 1.0f, 1.0f, p_114288_);
            float f10 = f * ((float)Math.PI * 2);
            this.leftWing.f_104203_ = 0.125f - (float)Math.cos(f10) * 0.2f;
            this.leftWing.f_104204_ = -0.25f;
            this.leftWing.f_104205_ = -((float)(Math.sin(f10) + 0.125)) * 0.8f;
            this.leftWingTip.f_104205_ = (float)(Math.sin(f10 + 2.0f) + 0.5) * 0.75f;
            this.rightWing.f_104203_ = this.leftWing.f_104203_;
            this.rightWing.f_104204_ = -this.leftWing.f_104204_;
            this.rightWing.f_104205_ = -this.leftWing.f_104205_;
            this.rightWingTip.f_104205_ = -this.leftWingTip.f_104205_;
            this.renderSide(p_114281_, p_114282_, p_114283_, p_114284_, f1, this.leftWing, this.leftFrontLeg, this.leftFrontLegTip, this.leftFrontFoot, this.leftRearLeg, this.leftRearLegTip, this.leftRearFoot, p_114288_);
            this.renderSide(p_114281_, p_114282_, p_114283_, p_114284_, f1, this.rightWing, this.rightFrontLeg, this.rightFrontLegTip, this.rightFrontFoot, this.rightRearLeg, this.rightRearLegTip, this.rightRearFoot, p_114288_);
            p_114281_.m_85849_();
            float f11 = -Mth.m_14031_((float)(f * ((float)Math.PI * 2))) * 0.0f;
            f8 = f * ((float)Math.PI * 2);
            f3 = 10.0f;
            f4 = 60.0f;
            f2 = 0.0f;
            adouble = this.entity.getLatencyPos(11, this.a);
            for (int j = 0; j < 12; ++j) {
                adouble2 = this.entity.getLatencyPos(12 + j, this.a);
                this.neck.f_104204_ = (Mth.m_14177_((float)((float)(adouble2[0] - adouble[0]))) * 1.5f + 180.0f) * ((float)Math.PI / 180);
                this.neck.f_104203_ = (f11 += Mth.m_14031_((float)((float)j * 0.45f + f8)) * 0.05f) + (float)(adouble2[1] - adouble[1]) * ((float)Math.PI / 180) * 1.5f * 5.0f;
                this.neck.f_104205_ = Mth.m_14177_((float)((float)(adouble2[0] - (double)f7))) * ((float)Math.PI / 180) * 1.5f;
                this.neck.f_104201_ = f3;
                this.neck.f_104202_ = f4;
                this.neck.f_104200_ = f2;
                f3 += Mth.m_14031_((float)this.neck.f_104203_) * 10.0f;
                f4 -= Mth.m_14089_((float)this.neck.f_104204_) * Mth.m_14089_((float)this.neck.f_104203_) * 10.0f;
                f2 -= Mth.m_14031_((float)this.neck.f_104204_) * Mth.m_14089_((float)this.neck.f_104203_) * 10.0f;
                this.neck.m_104306_(p_114281_, p_114282_, p_114283_, p_114284_, 1.0f, 1.0f, 1.0f, p_114288_);
            }
            p_114281_.m_85849_();
        }

        private void renderSide(PoseStack p_173978_, VertexConsumer p_173979_, int p_173980_, int p_173981_, float p_173982_, ModelPart p_173983_, ModelPart p_173984_, ModelPart p_173985_, ModelPart p_173986_, ModelPart p_173987_, ModelPart p_173988_, ModelPart p_173989_, float p_173990_) {
            p_173987_.f_104203_ = 1.0f + p_173982_ * 0.1f;
            p_173988_.f_104203_ = 0.5f + p_173982_ * 0.1f;
            p_173989_.f_104203_ = 0.75f + p_173982_ * 0.1f;
            p_173984_.f_104203_ = 1.3f + p_173982_ * 0.1f;
            p_173985_.f_104203_ = -0.5f - p_173982_ * 0.1f;
            p_173986_.f_104203_ = 0.75f + p_173982_ * 0.1f;
            p_173983_.m_104306_(p_173978_, p_173979_, p_173980_, p_173981_, 1.0f, 1.0f, 1.0f, p_173990_);
            p_173984_.m_104306_(p_173978_, p_173979_, p_173980_, p_173981_, 1.0f, 1.0f, 1.0f, p_173990_);
            p_173987_.m_104306_(p_173978_, p_173979_, p_173980_, p_173981_, 1.0f, 1.0f, 1.0f, p_173990_);
        }
    }
}

