/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui;

import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.client.ClientProxy;
import net.montoyo.wd.client.gui.GuiSubscribe;
import net.montoyo.wd.client.gui.WDScreen;
import net.montoyo.wd.client.gui.controls.Button;
import net.montoyo.wd.client.gui.controls.TextField;
import net.montoyo.wd.client.gui.loading.FillControl;
import net.montoyo.wd.entity.ScreenBlockEntity;
import net.montoyo.wd.item.ItemMinePad2;
import net.montoyo.wd.net.WDNetworkRegistry;
import net.montoyo.wd.net.server_bound.C2SMessageMinepadUrl;
import net.montoyo.wd.net.server_bound.C2SMessageScreenCtrl;
import net.montoyo.wd.utilities.data.BlockSide;
import net.montoyo.wd.utilities.math.Vector3i;
import net.montoyo.wd.utilities.serialization.Util;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class GuiSetURL2
extends WDScreen {
    private ScreenBlockEntity tileEntity;
    private BlockSide screenSide;
    private Vector3i remoteLocation;
    private ItemStack stack;
    private final boolean isPad;
    private final String screenURL;
    @FillControl
    private TextField tfURL;
    @FillControl
    private Button btnShutDown;
    @FillControl
    private Button btnCancel;
    @FillControl
    private Button btnOk;

    public GuiSetURL2(ScreenBlockEntity tes, BlockSide side, String url, Vector3i rl) {
        super(Component.m_130674_(null));
        this.tileEntity = tes;
        this.screenSide = side;
        this.remoteLocation = rl;
        this.isPad = false;
        this.screenURL = url;
    }

    public GuiSetURL2(ItemStack is, String url) {
        super(Component.m_130674_(null));
        this.isPad = true;
        this.stack = is;
        this.screenURL = url;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.loadFrom(new ResourceLocation("webdisplays", "gui/seturl.json"));
        this.tfURL.setText(this.screenURL);
    }

    @Override
    protected void addLoadCustomVariables(Map<String, Double> vars) {
        vars.put("isPad", this.isPad ? 1.0 : 0.0);
    }

    protected UUID getUUID() {
        if (this.stack == null || !(this.stack.m_41720_() instanceof ItemMinePad2)) {
            throw new RuntimeException("Get UUID is being called for a non-minepad UI");
        }
        if (!this.stack.m_41782_() || !this.stack.m_41783_().m_128441_("PadID")) {
            this.stack.m_41784_().m_128362_("PadID", UUID.randomUUID());
        }
        return this.stack.m_41783_().m_128342_("PadID");
    }

    @GuiSubscribe
    public void onButtonClicked(Button.ClickEvent ev) {
        if (ev.getSource() == this.btnCancel) {
            this.f_96541_.m_91152_(null);
        } else if (ev.getSource() == this.btnOk) {
            this.validate(this.tfURL.getText());
        } else if (ev.getSource() == this.btnShutDown) {
            if (this.isPad) {
                WDNetworkRegistry.INSTANCE.sendToServer((Object)new C2SMessageMinepadUrl(this.getUUID(), ""));
                this.stack.m_41783_().m_128473_("PadID");
            }
            this.f_96541_.m_91152_(null);
        }
    }

    @GuiSubscribe
    public void onEnterPressed(TextField.EnterPressedEvent ev) {
        this.validate(ev.getText());
    }

    private void validate(String url) {
        if (!url.isEmpty()) {
            try {
                ScreenBlockEntity.url(url);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            url = Util.addProtocol(url);
            if (this.isPad) {
                UUID uuid = this.getUUID();
                WDNetworkRegistry.INSTANCE.sendToServer((Object)new C2SMessageMinepadUrl(uuid, url));
                this.stack.m_41783_().m_128359_("PadURL", url);
                ClientProxy.PadData pd = ((ClientProxy)WebDisplays.PROXY).getPadByID(uuid);
                if (pd != null && pd.view != null) {
                    pd.view.loadURL(WebDisplays.applyBlacklist(url));
                }
            } else {
                WDNetworkRegistry.INSTANCE.sendToServer((Object)C2SMessageScreenCtrl.setURL(this.tileEntity, this.screenSide, url, this.remoteLocation));
            }
        }
        this.f_96541_.m_91152_(null);
    }

    @Override
    public boolean isForBlock(BlockPos bp, BlockSide side) {
        return this.remoteLocation != null && this.remoteLocation.equalsBlockPos(bp) || bp.equals((Object)this.tileEntity.m_58899_()) && side == this.screenSide;
    }
}

