/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui.camera;

import net.minecraft.client.Minecraft;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.montoyo.wd.client.gui.GuiKeyboard;
import net.montoyo.wd.config.ClientConfig;
import net.montoyo.wd.entity.ScreenBlockEntity;
import net.montoyo.wd.entity.ScreenData;
import net.montoyo.wd.utilities.browser.WDBrowser;
import net.montoyo.wd.utilities.browser.handlers.js.queries.ElementCenterQuery;
import net.montoyo.wd.utilities.data.BlockSide;
import org.cef.browser.CefBrowser;

public class KeyboardCamera {
    private static ScreenBlockEntity tes;
    private static BlockSide side;
    private static double oxCrd;
    private static double xCrd;
    private static double nxCrd;
    private static double oyCrd;
    private static double yCrd;
    private static double nyCrd;
    private static double nextX;
    private static double nextY;
    protected static int delay;

    protected static Vec2 pxToHit(ScreenData scr, Vec2 dst) {
        float cx;
        float cy;
        if (scr.rotation.isVertical) {
            cy = dst.f_82470_;
            cx = dst.f_82471_;
        } else {
            cx = dst.f_82470_;
            cy = dst.f_82471_;
        }
        cx /= (float)scr.resolution.x;
        cy /= (float)scr.resolution.y;
        switch (scr.rotation) {
            case ROT_270: {
                cx = 1.0f - cx;
                break;
            }
            case ROT_180: {
                cx = 1.0f - cx;
                cy = 1.0f - cy;
                break;
            }
            case ROT_90: {
                cy = 1.0f - cy;
            }
        }
        if (side != BlockSide.BOTTOM) {
            cy = 1.0f - cy;
        }
        float swInverse = (float)scr.size.x - 0.25f;
        float shInverse = (float)scr.size.y - 0.25f;
        cx *= swInverse;
        cy *= shInverse;
        if (KeyboardCamera.side.right.x > 0 || KeyboardCamera.side.right.z > 0) {
            cx += 1.0f;
        }
        if (side == BlockSide.TOP || side == BlockSide.BOTTOM) {
            cy -= 1.0f;
        }
        return new Vec2(cx + 0.125f, cy + 0.125f);
    }

    protected static void updateCrd(ElementCenterQuery lock) {
        ScreenData scr = tes.getScreen(side);
        if (scr != null) {
            Vec2 c;
            if (lock.hasFocused()) {
                if (ClientConfig.Input.keyboardCamera) {
                    nextX = lock.getX();
                    nextY = lock.getY();
                    c = KeyboardCamera.pxToHit(scr, new Vec2((float)nextX, (float)nextY));
                } else {
                    c = new Vec2((float)scr.size.x / 2.0f, (float)scr.size.y / 2.0f);
                }
            } else {
                c = new Vec2((float)scr.size.x / 2.0f, (float)scr.size.y / 2.0f);
            }
            nextX = c.f_82470_;
            nextY = c.f_82471_;
            if (nextX < 0.0) {
                nextX = 0.0;
            } else if (nextX > (double)scr.size.x) {
                nextX = scr.size.x;
            }
            if (nextY < 0.0) {
                nextY = 0.0;
            } else if (nextY > (double)scr.size.y) {
                nextY = scr.size.y;
            }
            float scl = Math.max(scr.size.x, scr.size.y);
            double mx = Minecraft.m_91087_().f_91067_.m_91589_();
            double my = Minecraft.m_91087_().f_91067_.m_91594_();
            Vec2 v2 = new Vec2((float)(mx /= (double)Minecraft.m_91087_().m_91268_().m_85441_()), (float)(my /= (double)Minecraft.m_91087_().m_91268_().m_85442_())).m_165908_(-0.5f);
            nextX += (double)(v2.f_82470_ * scl);
            nextY -= (double)(v2.f_82471_ * scl);
        }
    }

    protected static void pollElement() {
        CefBrowser cefBrowser;
        ScreenBlockEntity teTmp = tes;
        BlockSide sdTmp = side;
        if (teTmp == null || sdTmp == null) {
            return;
        }
        ScreenData scr = teTmp.getScreen(sdTmp);
        if (scr != null && (cefBrowser = scr.browser) instanceof WDBrowser) {
            WDBrowser wdBrowser = (WDBrowser)cefBrowser;
            wdBrowser.focusedElement().dispatch(scr.browser);
            KeyboardCamera.updateCrd(((WDBrowser)scr.browser).focusedElement());
        }
    }

    public static float[] getAngle(Entity e, double pct) {
        ScreenBlockEntity tes = KeyboardCamera.tes;
        BlockSide side = KeyboardCamera.side;
        if (tes == null) {
            return new float[]{Float.NaN, 0.0f};
        }
        if (side == null) {
            return new float[]{Float.NaN, 0.0f};
        }
        double coxCrd = Mth.m_14139_((double)(0.5 * pct), (double)oxCrd, (double)xCrd);
        double coyCrd = Mth.m_14139_((double)(0.5 * pct), (double)oyCrd, (double)yCrd);
        double focalX = (double)tes.m_58899_().m_123341_() + (double)side.right.x * (coxCrd - 1.0) + (double)side.up.x * coyCrd + (double)Math.abs(side.forward.x) * 0.5;
        double focalY = (double)tes.m_58899_().m_123342_() + (double)side.right.y * (coxCrd - 1.0) + (double)side.up.y * coyCrd + (double)Math.abs(side.forward.y) * 0.5;
        double focalZ = (double)tes.m_58899_().m_123343_() + (double)side.right.z * (coxCrd - 1.0) + (double)side.up.z * coyCrd + (double)Math.abs(side.forward.z) * 0.5;
        float[] angle = KeyboardCamera.lookAt(e, EntityAnchorArgument.Anchor.EYES, new Vec3(focalX += (double)((float)side.forward.x * 0.5f), focalY += (double)((float)side.forward.y * 0.5f), focalZ += (double)((float)side.forward.z * 0.5f)));
        return angle;
    }

    public static void updateCamera(ViewportEvent.ComputeCameraAngles event) {
        if (tes == null) {
            xCrd = -1.0;
            yCrd = -1.0;
            return;
        }
        if (xCrd == -1.0) {
            return;
        }
        if (yCrd == -1.0) {
            return;
        }
        float[] angle = KeyboardCamera.getAngle(event.getCamera().m_90592_(), event.getPartialTick());
        if (Float.isNaN(angle[0])) {
            return;
        }
        event.setYaw(angle[1]);
        event.setPitch(angle[0]);
    }

    public static void focus(ScreenBlockEntity screen, BlockSide side) {
        tes = screen;
        KeyboardCamera.side = side;
    }

    public static float[] lookAt(Entity entity, EntityAnchorArgument.Anchor pAnchor, Vec3 pTarget) {
        Vec3 vec3 = pAnchor.m_90377_(entity);
        double d0 = pTarget.f_82479_ - vec3.f_82479_;
        double d1 = pTarget.f_82480_ - vec3.f_82480_;
        double d2 = pTarget.f_82481_ - vec3.f_82481_;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        float xr = Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875))));
        float yr = Mth.m_14177_((float)((float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f));
        return new float[]{xr, yr};
    }

    public static void gameTick(TickEvent.ClientTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.END)) {
            if (side == null) {
                delay = 1;
                oxCrd = -1.0;
                oyCrd = -1.0;
                xCrd = -1.0;
                yCrd = -1.0;
                nxCrd = -1.0;
                nyCrd = -1.0;
                return;
            }
            if (!(Minecraft.m_91087_().f_91080_ instanceof GuiKeyboard)) {
                tes = null;
                side = null;
                return;
            }
            KeyboardCamera.pollElement();
            double anxx = nextX;
            double anxy = nextY;
            if (anxx == -1.0 || anxy == -1.0 || nxCrd == -1.0 || nyCrd == -1.0 || oxCrd == -1.0 || oyCrd == -1.0 || xCrd == -1.0 || yCrd == -1.0) {
                ScreenData data = tes.getScreen(side);
                if (data == null) {
                    return;
                }
                anxx = (double)data.size.x / 2.0;
                anxy = (double)data.size.y / 2.0;
                if (nxCrd == -1.0) {
                    oxCrd = xCrd = anxx;
                    oyCrd = yCrd = anxy;
                }
            }
            nxCrd = anxx;
            nyCrd = anxy;
            oxCrd = Mth.m_14139_((double)0.5, (double)oxCrd, (double)xCrd);
            xCrd = Mth.m_14139_((double)0.15, (double)xCrd, (double)nxCrd);
            oyCrd = Mth.m_14139_((double)0.5, (double)oyCrd, (double)yCrd);
            yCrd = Mth.m_14139_((double)0.15, (double)yCrd, (double)nyCrd);
        }
    }

    static {
        oxCrd = -1.0;
        xCrd = -1.0;
        nxCrd = -1.0;
        oyCrd = -1.0;
        yCrd = -1.0;
        nyCrd = -1.0;
        nextX = -1.0;
        nextY = -1.0;
        delay = 8;
    }
}

