/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.controls.builtin;

import io.netty.buffer.ByteBuf;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.montoyo.wd.controls.ScreenControl;
import net.montoyo.wd.controls.builtin.ClickControl;
import net.montoyo.wd.core.MissingPermissionException;
import net.montoyo.wd.entity.ScreenBlockEntity;
import net.montoyo.wd.utilities.data.BlockSide;
import net.montoyo.wd.utilities.math.Vector2i;

public class LaserControl
extends ScreenControl {
    public static final ResourceLocation id = new ResourceLocation("webdisplays:laser");
    ControlType type;
    Vector2i coord;
    int button;

    public LaserControl(ControlType type, Vector2i coord) {
        this(type, coord, -1);
    }

    public LaserControl(ControlType type, Vector2i coord, int button) {
        super(id);
        this.type = type;
        this.coord = coord;
        this.button = button;
    }

    public LaserControl(FriendlyByteBuf buf) {
        super(id);
        this.type = ControlType.values()[buf.readByte()];
        if (!this.type.equals((Object)ControlType.UP)) {
            this.coord = new Vector2i((ByteBuf)buf);
        }
        if (!this.type.equals((Object)ControlType.MOVE)) {
            this.button = buf.readInt();
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeByte(this.type.ordinal());
        if (this.coord != null) {
            this.coord.writeTo((ByteBuf)buf);
        }
        if (this.type != ControlType.MOVE) {
            buf.writeInt(this.button);
        }
    }

    @Override
    public void handleServer(BlockPos pos, BlockSide side, ScreenBlockEntity tes, NetworkEvent.Context ctx, Function<Integer, Boolean> permissionChecker) throws MissingPermissionException {
        ServerPlayer sender = ctx.getSender();
        switch (this.type) {
            case UP: {
                tes.laserUp(side, (Player)sender, this.button);
                break;
            }
            case DOWN: {
                tes.laserDownMove(side, (Player)sender, this.coord, true, this.button);
                break;
            }
            case MOVE: {
                tes.laserDownMove(side, (Player)sender, this.coord, false, this.button);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleClient(BlockPos pos, BlockSide side, ScreenBlockEntity tes, NetworkEvent.Context ctx) {
        if (this.coord != null) {
            tes.handleMouseEvent(side, ClickControl.ControlType.MOVE, this.coord, -1);
        }
        switch (this.type) {
            case UP: {
                tes.handleMouseEvent(side, ClickControl.ControlType.UP, this.coord, this.button);
                break;
            }
            case DOWN: {
                tes.handleMouseEvent(side, ClickControl.ControlType.DOWN, this.coord, this.button);
            }
        }
    }

    public static enum ControlType {
        MOVE,
        DOWN,
        UP;

    }
}

