/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.controls.builtin;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.montoyo.wd.controls.ScreenControl;
import net.montoyo.wd.core.MissingPermissionException;
import net.montoyo.wd.entity.ScreenBlockEntity;
import net.montoyo.wd.utilities.data.BlockSide;
import net.montoyo.wd.utilities.serialization.NameUUIDPair;

public class ModifyFriendListControl
extends ScreenControl {
    public static final ResourceLocation id = new ResourceLocation("webdisplays:mod_friend_list");
    boolean adding;
    NameUUIDPair friend;

    public ModifyFriendListControl(NameUUIDPair pair, boolean adding) {
        super(id);
        this.adding = adding;
        this.friend = pair;
    }

    public ModifyFriendListControl(FriendlyByteBuf buf) {
        super(id);
        this.adding = buf.readBoolean();
        this.friend = new NameUUIDPair(buf);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.adding);
        this.friend.writeTo(buf);
    }

    @Override
    public void handleServer(BlockPos pos, BlockSide side, ScreenBlockEntity tes, NetworkEvent.Context ctx, Function<Integer, Boolean> permissionChecker) throws MissingPermissionException {
        ServerPlayer player = ctx.getSender();
        this.checkPerms(4, permissionChecker, ctx.getSender());
        if (this.adding) {
            tes.addFriend(player, side, this.friend);
        } else {
            tes.removeFriend(player, side, this.friend);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleClient(BlockPos pos, BlockSide side, ScreenBlockEntity tes, NetworkEvent.Context ctx) {
        throw new RuntimeException("TODO");
    }
}

