/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.data;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;
import net.montoyo.wd.data.KeyboardData;
import net.montoyo.wd.data.RedstoneCtrlData;
import net.montoyo.wd.data.ScreenConfigData;
import net.montoyo.wd.data.ServerData;
import net.montoyo.wd.data.SetURLData;
import net.montoyo.wd.net.WDNetworkRegistry;
import net.montoyo.wd.net.client_bound.S2CMessageOpenGui;

public abstract class GuiData {
    private static final HashMap<String, GuiType> dataTable = new HashMap();

    public static GuiData read(String name, FriendlyByteBuf buf) {
        GuiType type = dataTable.get(name);
        GuiData data = type.create();
        data.deserialize(buf);
        return data;
    }

    public static Class<? extends GuiData> classOf(String name) {
        return GuiData.dataTable.get((Object)name).clazz;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract Screen createGui(Screen var1, Level var2);

    public abstract String getName();

    public void sendTo(ServerPlayer player) {
        WDNetworkRegistry.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CMessageOpenGui(this));
    }

    public abstract void serialize(FriendlyByteBuf var1);

    public abstract void deserialize(FriendlyByteBuf var1);

    static {
        dataTable.put("SetURL", new GuiType(SetURLData.class, SetURLData::new));
        dataTable.put("ScreenConfig", new GuiType(ScreenConfigData.class, ScreenConfigData::new));
        dataTable.put("Keyboard", new GuiType(KeyboardData.class, KeyboardData::new));
        dataTable.put("RedstoneCtrl", new GuiType(RedstoneCtrlData.class, RedstoneCtrlData::new));
        dataTable.put("Server", new GuiType(ServerData.class, ServerData::new));
    }

    protected static class GuiType {
        Class<? extends GuiData> clazz;
        Supplier<GuiData> constructor;

        public GuiType(Class<? extends GuiData> clazz, Supplier<GuiData> constructor) {
            this.clazz = clazz;
            this.constructor = constructor;
        }

        public GuiData create() {
            return this.constructor.get();
        }
    }
}

