/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.miniserv.client;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayDeque;
import java.util.UUID;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.montoyo.wd.miniserv.AbstractClient;
import net.montoyo.wd.miniserv.OutgoingPacket;
import net.montoyo.wd.miniserv.PacketHandler;
import net.montoyo.wd.miniserv.PacketID;
import net.montoyo.wd.miniserv.client.ClientTask;
import net.montoyo.wd.miniserv.client.ClientTaskCheckFile;
import net.montoyo.wd.miniserv.client.ClientTaskDeleteFile;
import net.montoyo.wd.miniserv.client.ClientTaskGetFile;
import net.montoyo.wd.miniserv.client.ClientTaskGetFileList;
import net.montoyo.wd.miniserv.client.ClientTaskGetQuota;
import net.montoyo.wd.miniserv.client.ClientTaskUploadFile;
import net.montoyo.wd.net.server_bound.C2SMessageMiniservConnect;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.serialization.Util;

public class Client
extends AbstractClient
implements Runnable {
    private static Client instance;
    private final SecureRandom random = new SecureRandom();
    private KeyPair keyPair;
    private byte[] key;
    private SocketAddress address;
    private volatile boolean running;
    private volatile boolean connected;
    private final ByteBuffer readBuffer = ByteBuffer.allocateDirect(8192);
    private volatile Thread thread;
    private UUID clientUUID;
    private final ArrayDeque<ClientTask> tasks = new ArrayDeque();
    private ClientTask currentTask;
    private volatile boolean authenticated;
    private long lastPingTime;

    public static Client getInstance() {
        if (instance == null) {
            instance = new Client();
        }
        return instance;
    }

    public C2SMessageMiniservConnect beginConnection() {
        if (this.keyPair == null) {
            try {
                KeyPairGenerator keygen = KeyPairGenerator.getInstance("RSA");
                keygen.initialize(2048);
                this.keyPair = keygen.generateKeyPair();
            }
            catch (NoSuchAlgorithmException ex) {
                Log.warningEx("RSA is unsupported?!?!", ex, new Object[0]);
                return null;
            }
        }
        RSAPublicKey pubKey = (RSAPublicKey)this.keyPair.getPublic();
        return new C2SMessageMiniservConnect(pubKey.getModulus().toByteArray(), pubKey.getPublicExponent().toByteArray());
    }

    public boolean decryptKey(byte[] encKey) {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(2, (Key)this.keyPair.getPrivate(), this.random);
            this.key = cipher.doFinal(encKey);
            return true;
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException ex) {
            Log.warningEx("%s unsupported...", ex, "RSA/ECB/PKCS1Padding");
        }
        catch (InvalidKeyException ex) {
            Log.warningEx("The generated key is invalid...", ex, new Object[0]);
        }
        catch (BadPaddingException | IllegalBlockSizeException ex) {
            Log.warningEx("Could not decrypt key", ex, new Object[0]);
        }
        return false;
    }

    private byte[] authenticate(byte[] challenge) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(this.key, "HmacSHA256"));
            return mac.doFinal(challenge);
        }
        catch (NoSuchAlgorithmException ex) {
            Log.warningEx("%s unsupported...", ex, "HmacSHA256");
        }
        catch (InvalidKeyException ex) {
            Log.warningEx("The key given by the server is invalid", ex, new Object[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(SocketAddress addr) {
        if (this.getRunning()) {
            Log.warning("Called Client.start() twice", new Object[0]);
            return;
        }
        this.address = addr;
        this.thread = new Thread(this);
        this.thread.setName("MiniServClient");
        this.thread.setDaemon(true);
        Client client = this;
        synchronized (client) {
            this.running = true;
            this.connected = false;
        }
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.getRunning()) {
            Thread thread = this.thread;
            Client client = this;
            synchronized (client) {
                this.running = false;
                if (this.connected) {
                    this.selector.wakeup();
                }
            }
            while (thread.isAlive()) {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            Log.info("Miniserv client stopped", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getRunning() {
        boolean ret;
        Client client = this;
        synchronized (client) {
            ret = this.running;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.clientUUID == null) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                this.clientUUID = player.m_36316_().getId();
            } else {
                return;
            }
        }
        try {
            this.selector = Selector.open();
            this.socket = SocketChannel.open();
            this.socket.connect(this.address);
            this.socket.configureBlocking(false);
            this.selKey = this.socket.register(this.selector, 1);
        }
        catch (IOException ex) {
            Log.errorEx("Couldn't start client", ex, new Object[0]);
            Client client = this;
            synchronized (client) {
                this.running = false;
            }
            return;
        }
        Client ex = this;
        synchronized (ex) {
            this.connected = true;
        }
        Log.info("Miniserv client connected!", new Object[0]);
        OutgoingPacket connPacket = new OutgoingPacket();
        connPacket.writeByte(PacketID.INIT_CONN.ordinal());
        connPacket.writeLong(this.clientUUID.getMostSignificantBits());
        connPacket.writeLong(this.clientUUID.getLeastSignificantBits());
        this.sendPacket(connPacket);
        this.lastPingTime = System.currentTimeMillis();
        while (this.getRunning()) {
            try {
                this.unsafeLoop();
            }
            catch (Throwable t) {
                Log.errorEx("MiniServ Client crashed", t, new Object[0]);
                break;
            }
        }
        Object object = this;
        synchronized (object) {
            this.connected = false;
            this.running = false;
            this.authenticated = false;
        }
        Util.silentClose(this.selector);
        Util.silentClose(this.socket);
        this.selector = null;
        this.socket = null;
        if (this.currentTask != null) {
            this.currentTask.abort();
            this.currentTask.onFinished();
            this.currentTask = null;
        }
        object = this.tasks;
        synchronized (object) {
            ClientTask task;
            while ((task = this.tasks.poll()) != null) {
                task.abort();
                task.onFinished();
            }
        }
        this.clearSendQueue();
        this.thread = null;
    }

    private void unsafeLoop() throws Throwable {
        long timeBeforePing = 5000L - (System.currentTimeMillis() - this.lastPingTime);
        this.selector.select(Math.max(0L, timeBeforePing));
        if (this.currentTask == null || this.currentTask.isCanceled()) {
            this.nextTask();
        }
        for (SelectionKey key : this.selector.selectedKeys()) {
            if (key.isReadable()) {
                this.readBuffer.clear();
                int rd = this.socket.read(this.readBuffer);
                if (rd < 0) {
                    Log.warning("Connection was closed, stopping...", new Object[0]);
                    this.running = false;
                } else if (rd > 0) {
                    this.readBuffer.position(0);
                    this.readBuffer.limit(rd);
                    this.readyRead(this.readBuffer);
                }
            }
            if (!key.isWritable()) continue;
            try {
                this.readyWrite();
            }
            catch (Throwable t) {
                Log.errorEx("Caught error while sending data to miniserv, stopping...", t, new Object[0]);
                this.running = false;
            }
        }
        long t = System.currentTimeMillis();
        if (t - this.lastPingTime >= 5000L) {
            OutgoingPacket pkt = new OutgoingPacket();
            pkt.writeByte(PacketID.PING.ordinal());
            this.sendPacket(pkt);
            this.lastPingTime = t;
        }
    }

    @Override
    protected void onWriteError() {
        this.running = false;
        Log.error("Write error, stopping...", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PacketHandler(value=PacketID.AUTHENTICATE)
    public void handleAuth(DataInputStream dis) throws IOException {
        byte len = dis.readByte();
        byte[] challenge = new byte[len];
        dis.readFully(challenge);
        byte[] mac = this.authenticate(challenge);
        OutgoingPacket pkt = new OutgoingPacket();
        pkt.writeByte(PacketID.AUTHENTICATE.ordinal());
        pkt.writeByte(mac.length);
        pkt.writeBytes(mac);
        this.sendPacket(pkt);
        Log.info("Miniserv client authenticated", new Object[0]);
        Client client = this;
        synchronized (client) {
            this.authenticated = true;
        }
    }

    @PacketHandler(value=PacketID.BEGIN_FILE_UPLOAD)
    public void handleBeginUpload(DataInputStream dis) throws IOException {
        if (this.currentTask instanceof ClientTaskUploadFile) {
            ((ClientTaskUploadFile)this.currentTask).onReceivedUploadStatus(dis.readByte());
        }
    }

    @PacketHandler(value=PacketID.FILE_STATUS)
    public void handleFileStatus(DataInputStream dis) throws IOException {
        if (this.currentTask instanceof ClientTaskUploadFile) {
            ((ClientTaskUploadFile)this.currentTask).onUploadFinishedStatus(dis.readByte());
        }
    }

    @PacketHandler(value=PacketID.GET_FILE)
    public void handleGetFile(DataInputStream dis) throws IOException {
        if (this.currentTask instanceof ClientTaskGetFile) {
            ((ClientTaskGetFile)this.currentTask).onGetFileResponse(dis.readByte());
        } else if (this.currentTask instanceof ClientTaskCheckFile) {
            ((ClientTaskCheckFile)this.currentTask).onStatus(dis.readByte());
        }
    }

    @PacketHandler(value=PacketID.FILE_PART)
    public void handleFilePart(DataInputStream dis) throws IOException {
        if (this.currentTask instanceof ClientTaskGetFile) {
            int len = dis.readShort() & 0xFFFF;
            ((ClientTaskGetFile)this.currentTask).onData(this.getCurrentPacketRawData(), len);
        }
    }

    @PacketHandler(value=PacketID.QUOTA)
    public void handleQuota(DataInputStream dis) throws IOException {
        long q = dis.readLong();
        long m = dis.readLong();
        if (this.currentTask instanceof ClientTaskGetQuota) {
            ((ClientTaskGetQuota)this.currentTask).onQuotaData(q, m);
        }
    }

    @PacketHandler(value=PacketID.LIST)
    public void handleList(DataInputStream dis) throws IOException {
        int cnt = dis.readByte() & 0xFF;
        String[] files = new String[cnt];
        for (int i = 0; i < cnt; ++i) {
            files[i] = Client.readString(dis);
        }
        if (this.currentTask instanceof ClientTaskGetFileList) {
            ((ClientTaskGetFileList)this.currentTask).onFileList(files);
        }
    }

    @PacketHandler(value=PacketID.DELETE)
    public void handleDelete(DataInputStream dis) throws IOException {
        if (this.currentTask instanceof ClientTaskDeleteFile) {
            ((ClientTaskDeleteFile)this.currentTask).onStatusPacket(dis.readByte());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextTask() {
        if (this.currentTask != null) {
            this.currentTask.onFinished();
        }
        ArrayDeque<ClientTask> arrayDeque = this.tasks;
        synchronized (arrayDeque) {
            this.currentTask = this.tasks.poll();
        }
        if (this.currentTask != null) {
            this.currentTask.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTask(ClientTask task) {
        boolean cancel;
        Object object = this;
        synchronized (object) {
            cancel = !this.running || !this.authenticated;
        }
        if (cancel) {
            return false;
        }
        object = this.tasks;
        synchronized (object) {
            this.tasks.offer(task);
        }
        this.selector.wakeup();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        boolean conn;
        Client client = this;
        synchronized (client) {
            conn = this.connected;
        }
        if (conn) {
            this.selector.wakeup();
        }
    }

    @Override
    protected void onDataSent() {
        this.lastPingTime = System.currentTimeMillis();
    }
}

