/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.miniserv.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.montoyo.wd.miniserv.OutgoingPacket;
import net.montoyo.wd.miniserv.PacketID;
import net.montoyo.wd.miniserv.client.ClientTask;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.serialization.Util;

public class ClientTaskUploadFile
extends ClientTask<ClientTaskUploadFile>
implements Consumer<OutgoingPacket> {
    private static final byte[] UPLOAD_BUFFER = new byte[65535];
    private final File file;
    private final long size;
    private FileInputStream fis;
    private boolean abortFupa;
    private int uploadStatus;
    private long uploadPos;
    private BiConsumer<Long, Long> onProgress;

    public ClientTaskUploadFile(File fle) throws IOException {
        this.file = fle;
        this.size = Files.size(fle.toPath());
        this.fis = new FileInputStream(fle);
        this.runCallbackOnMcThread = true;
    }

    @Override
    public void start() {
        OutgoingPacket pkt = new OutgoingPacket();
        pkt.writeByte(PacketID.BEGIN_FILE_UPLOAD.ordinal());
        pkt.writeString(this.file.getName());
        pkt.writeLong(this.size);
        this.client.sendPacket(pkt);
    }

    @Override
    public void abort() {
        this.abortFupa = true;
        this.uploadStatus = 9;
        Util.silentClose(this.fis);
    }

    public void onReceivedUploadStatus(int status) {
        if (status == 0) {
            Log.info("Now uploading %s", this.file.getName());
            this.accept(null);
        } else {
            Util.silentClose(this.fis);
            this.uploadStatus = status;
            this.client.nextTask();
        }
    }

    public void onUploadFinishedStatus(int status) {
        this.abortFupa = true;
        this.uploadStatus = status;
        this.client.nextTask();
    }

    @Override
    public void accept(OutgoingPacket nocare) {
        int rd;
        if (this.abortFupa) {
            return;
        }
        do {
            try {
                rd = this.fis.read(UPLOAD_BUFFER);
            }
            catch (IOException ex) {
                Log.warningEx("Caught IOException while sending some file", ex, new Object[0]);
                rd = 0;
                break;
            }
        } while (rd == 0);
        if (rd >= 0) {
            OutgoingPacket pkt = new OutgoingPacket();
            pkt.writeByte(PacketID.FILE_PART.ordinal());
            pkt.writeShort(rd);
            pkt.writeBytes(UPLOAD_BUFFER, 0, rd);
            this.client.sendPacket(pkt);
            if (this.onProgress != null) {
                this.uploadPos += (long)rd;
                this.onProgress.accept(this.uploadPos, this.size);
            }
            if (rd > 0) {
                pkt.setOnFinishAction(this);
                return;
            }
        }
        Util.silentClose(this.file);
    }

    public int getUploadStatus() {
        return this.uploadStatus;
    }

    public void setProgressCallback(BiConsumer<Long, Long> onProgress) {
        this.onProgress = onProgress;
    }
}

