/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.net.server_bound;

import com.mojang.authlib.GameProfile;
import java.util.Arrays;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.net.Packet;
import net.montoyo.wd.net.WDNetworkRegistry;
import net.montoyo.wd.net.client_bound.S2CMessageACResult;
import net.montoyo.wd.utilities.serialization.NameUUIDPair;

public class C2SMessageACQuery
extends Packet
implements Runnable {
    private ServerPlayer player;
    private String beginning;
    private boolean matchExact;

    public C2SMessageACQuery(String beg, boolean exact) {
        this.beginning = beg;
        this.matchExact = exact;
    }

    public C2SMessageACQuery(FriendlyByteBuf buf) {
        super(buf);
        this.beginning = buf.m_130277_();
        this.matchExact = buf.readBoolean();
    }

    @Override
    public void m_5779_(FriendlyByteBuf buf) {
        buf.m_130070_(this.beginning);
        buf.writeBoolean(this.matchExact);
    }

    @Override
    public void run() {
        NameUUIDPair[] result;
        GameProfile[] profiles = WebDisplays.PROXY.getOnlineGameProfiles();
        if (this.matchExact) {
            result = (NameUUIDPair[])Arrays.stream(profiles).filter(gp -> gp.getName().equalsIgnoreCase(this.beginning)).map(NameUUIDPair::new).toArray(NameUUIDPair[]::new);
        } else {
            String lBeg = this.beginning.toLowerCase();
            result = (NameUUIDPair[])Arrays.stream(profiles).filter(gp -> gp.getName().toLowerCase().startsWith(lBeg)).map(NameUUIDPair::new).toArray(NameUUIDPair[]::new);
        }
        WDNetworkRegistry.INSTANCE.send(PacketDistributor.PLAYER.with(() -> this.player), (Object)new S2CMessageACResult(result));
    }

    @Override
    public void handle(NetworkEvent.Context ctx) {
        if (this.checkServer(ctx)) {
            this.player = ctx.getSender();
            ctx.enqueueWork((Runnable)this);
            ctx.setPacketHandled(true);
        }
    }
}

