/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.utilities;

import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum VideoType {
    YOUTUBE("document.getElementById(\"movie_player\").", new Function("setVolume(", ")"), new Function("getCurrentTime(", ")"), new Function("seekTo(", ")")),
    YOUTUBE_EMBED("document.getElementsByClassName(\"html5-video-player\")[0].", new Function("setVolume(", ")"), new Function("getCurrentTime(", ")"), new Function("seekTo(", ")"));

    private final String base;
    private final Function volume;
    private final Function getTime;
    private final Function setTime;
    private final int volumeCap;

    private VideoType(String base, Function volume, Function getTime, Function setTime) {
        this.base = base;
        this.volume = volume;
        this.getTime = getTime;
        this.setTime = setTime;
        this.volumeCap = volume.prefix.length() + 5 + volume.suffix.length();
    }

    @Nullable
    public static VideoType getTypeFromURL(@Nonnull URL url) {
        String loHost = url.getHost().toLowerCase();
        if (loHost.equals("youtu.be")) {
            return url.getPath().length() > 1 ? YOUTUBE : null;
        }
        if (!loHost.equals("www.youtube.com") && !loHost.equals("youtube.com")) {
            return null;
        }
        String loPath = url.getPath().toLowerCase();
        if (loPath.equals("/watch")) {
            if (url.getQuery() != null && (url.getQuery().startsWith("v=") || url.getQuery().contains("&v="))) {
                return YOUTUBE;
            }
        } else if (loPath.startsWith("/embed/")) {
            return loPath.length() > 7 ? YOUTUBE_EMBED : null;
        }
        return null;
    }

    @Nullable
    public static VideoType getTypeFromURL(@Nonnull String url) {
        try {
            return VideoType.getTypeFromURL(new URL(url));
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    @Nonnull
    public String getVideoIDFromURL(@Nonnull URL url) {
        if (this == YOUTUBE) {
            String[] args;
            if (url.getHost().equalsIgnoreCase("youtu.be")) {
                return url.getPath().substring(1);
            }
            for (String arg : args = url.getQuery().split("&")) {
                if (!arg.startsWith("v=")) continue;
                return arg.substring(2);
            }
        } else if (this == YOUTUBE_EMBED) {
            return url.getPath().substring(7);
        }
        return "";
    }

    @Nonnull
    public String getURLFromID(@Nonnull String vid, boolean autoplay) {
        String format;
        if (this == YOUTUBE) {
            format = autoplay ? "https://www.youtube.com/watch?v=%s&autoplay=1" : "https://www.youtube.com/watch?v=%s";
        } else if (this == YOUTUBE_EMBED) {
            format = autoplay ? "https://www.youtube.com/embed/%s?autoplay=1" : "https://www.youtube.com/embed/%s";
        } else {
            return "";
        }
        return String.format(format, vid);
    }

    @Nonnull
    public String getVolumeJSQuery(int volInt, int volFrac) {
        return this.volume.apply(volInt + "." + volFrac);
    }

    public String getTimeStampQuery() {
        return this.getTime.apply();
    }

    public String setTimeStampQuery(float ts) {
        return this.setTime.apply(String.valueOf(ts));
    }

    protected static class Function {
        String prefix;
        String suffix;

        public Function(String prefix, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
        }

        public String apply() {
            return this.prefix + this.suffix;
        }

        public String apply(String arg) {
            return this.prefix + arg + this.suffix;
        }
    }
}

