/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.utilities.data;

import net.montoyo.wd.utilities.math.Vector3i;

public enum BlockSide {
    BOTTOM(new Vector3i(0, 0, -1), new Vector3i(1, 0, 0), new Vector3i(0, -1, 0)),
    TOP(new Vector3i(0, 0, -1), new Vector3i(1, 0, 0), new Vector3i(0, 1, 0)),
    NORTH(new Vector3i(0, 1, 0), new Vector3i(-1, 0, 0), new Vector3i(0, 0, -1)),
    SOUTH(new Vector3i(0, 1, 0), new Vector3i(1, 0, 0), new Vector3i(0, 0, 1)),
    WEST(new Vector3i(0, 1, 0), new Vector3i(0, 0, 1), new Vector3i(-1, 0, 0)),
    EAST(new Vector3i(0, 1, 0), new Vector3i(0, 0, -1), new Vector3i(1, 0, 0));

    public final Vector3i up;
    public final Vector3i down;
    public final Vector3i left;
    public final Vector3i right;
    public final Vector3i forward;
    public final Vector3i backward;
    public final Vector3i horizontal;
    public final Vector3i vertical;

    private BlockSide(Vector3i u, Vector3i r, Vector3i f) {
        this.up = u;
        this.right = r;
        this.forward = f;
        this.down = u.clone().neg();
        this.left = r.clone().neg();
        this.backward = f.clone().neg();
        this.horizontal = new Vector3i(Math.abs(r.x), Math.abs(r.y), Math.abs(r.z));
        this.vertical = new Vector3i(Math.abs(u.x), Math.abs(u.y), Math.abs(u.z));
    }

    public BlockSide reverse() {
        int side = this.ordinal();
        int div = side / 2;
        int rest = 1 - side % 2;
        return BlockSide.values()[div * 2 + rest];
    }

    public static int reverse(int side) {
        int div = side / 2;
        int rest = 1 - side % 2;
        return div * 2 + rest;
    }

    public static BlockSide fromInt(int s) {
        BlockSide[] values = BlockSide.values();
        return s < 0 || s >= values.length ? null : values[s];
    }
}

