/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.utilities.serialization;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;

public final class NameUUIDPair {
    public final String name;
    public final UUID uuid;

    public NameUUIDPair() {
        this.name = "";
        this.uuid = new UUID(0L, 0L);
    }

    public NameUUIDPair(String name, UUID uuid) {
        this.name = name;
        this.uuid = uuid;
    }

    public NameUUIDPair(GameProfile profile) {
        this.name = profile.getName();
        this.uuid = profile.getId();
    }

    public NameUUIDPair(FriendlyByteBuf bb) {
        this.name = bb.m_130277_();
        long msb = bb.readLong();
        long lsb = bb.readLong();
        this.uuid = new UUID(msb, lsb);
    }

    public String getName() {
        return this.name;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof NameUUIDPair)) {
            return false;
        }
        return ((NameUUIDPair)obj).uuid.equals(this.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public boolean isBlank() {
        return this.name.isEmpty() && this.uuid.getMostSignificantBits() == 0L && this.uuid.getLeastSignificantBits() == 0L;
    }

    public void writeTo(FriendlyByteBuf bb) {
        bb.m_130070_(this.name);
        bb.writeLong(this.uuid.getMostSignificantBits());
        bb.writeLong(this.uuid.getLeastSignificantBits());
    }
}

